/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.policy;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public interface AlterConfigPolicy
extends Configurable,
AutoCloseable {
    public void validate(RequestMetadata var1) throws PolicyViolationException;

    public static class RequestMetadata {
        private final ConfigResource resource;
        private final Map<String, String> configs;
        private final KafkaPrincipal principal;

        public RequestMetadata(ConfigResource resource, Map<String, String> configs) {
            this(resource, configs, null);
        }

        public RequestMetadata(ConfigResource resource, Map<String, String> configs, KafkaPrincipal principal) {
            this.resource = resource;
            this.configs = configs;
            this.principal = principal;
        }

        public KafkaPrincipal principal() {
            return this.principal;
        }

        public Map<String, String> configs() {
            return this.configs;
        }

        public ConfigResource resource() {
            return this.resource;
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.configs, this.principal);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            RequestMetadata other = (RequestMetadata)o;
            return this.resource.equals(other.resource) && this.configs.equals(other.configs) && Objects.equals(this.principal, other.principal);
        }

        public String toString() {
            return "AlterConfigPolicy.RequestMetadata(resource=" + String.valueOf(this.resource) + ", configs=" + String.valueOf(this.configs) + ", principal=" + String.valueOf(this.principal) + ")";
        }
    }
}

