/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.message.TriggerEvenClusterLoadRequestData;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadResponse;

public class TriggerEvenClusterLoadRequest
extends AbstractRequest {
    private TriggerEvenClusterLoadRequestData data;

    public TriggerEvenClusterLoadRequest(TriggerEvenClusterLoadRequestData data, short apiVersion) {
        super(ApiKeys.TRIGGER_EVEN_CLUSTER_LOAD, apiVersion);
        this.data = data;
    }

    @Override
    public TriggerEvenClusterLoadRequestData data() {
        return this.data;
    }

    @Override
    public TriggerEvenClusterLoadResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        TriggerEvenClusterLoadResponseData responseData = new TriggerEvenClusterLoadResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new TriggerEvenClusterLoadResponse(responseData);
    }

    public static TriggerEvenClusterLoadRequest parse(Readable readable, short version, MessageContext context) {
        return new TriggerEvenClusterLoadRequest(new TriggerEvenClusterLoadRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<TriggerEvenClusterLoadRequest> {
        private final TriggerEvenClusterLoadRequestData data;

        public Builder(List<String> goalList) {
            super(ApiKeys.TRIGGER_EVEN_CLUSTER_LOAD);
            this.data = new TriggerEvenClusterLoadRequestData().setGoals(goalList);
        }

        @Override
        public TriggerEvenClusterLoadRequest build(short apiVersion) {
            return new TriggerEvenClusterLoadRequest(this.data, apiVersion);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

