/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class StreamsGroupDescribeResponse
extends AbstractResponse {
    private final StreamsGroupDescribeResponseData data;

    public StreamsGroupDescribeResponse(StreamsGroupDescribeResponseData data) {
        super(ApiKeys.STREAMS_GROUP_DESCRIBE);
        this.data = data;
    }

    @Override
    public StreamsGroupDescribeResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.groups().forEach(group -> StreamsGroupDescribeResponse.updateErrorCounts(counts, Errors.forCode(group.errorCode())));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static StreamsGroupDescribeResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new StreamsGroupDescribeResponse(new StreamsGroupDescribeResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

