/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;

public class ShareGroupHeartbeatRequest
extends AbstractRequest {
    public static final int LEAVE_GROUP_MEMBER_EPOCH = -1;
    public static final int JOIN_GROUP_MEMBER_EPOCH = 0;
    private final ShareGroupHeartbeatRequestData data;

    public ShareGroupHeartbeatRequest(ShareGroupHeartbeatRequestData data, short version) {
        super(ApiKeys.SHARE_GROUP_HEARTBEAT, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    @Override
    public ShareGroupHeartbeatRequestData data() {
        return this.data;
    }

    public static ShareGroupHeartbeatRequest parse(Readable readable, short version, MessageContext context) {
        return new ShareGroupHeartbeatRequest(new ShareGroupHeartbeatRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ShareGroupHeartbeatRequest> {
        private final ShareGroupHeartbeatRequestData data;

        public Builder(ShareGroupHeartbeatRequestData data) {
            this(data, true);
        }

        public Builder(ShareGroupHeartbeatRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.SHARE_GROUP_HEARTBEAT, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public ShareGroupHeartbeatRequest build(short version) {
            return new ShareGroupHeartbeatRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

