/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ShareGroupDescribeRequestData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ShareGroupDescribeResponse;

public class ShareGroupDescribeRequest
extends AbstractRequest {
    private final ShareGroupDescribeRequestData data;

    public ShareGroupDescribeRequest(ShareGroupDescribeRequestData data, short version) {
        super(ApiKeys.SHARE_GROUP_DESCRIBE, version);
        this.data = data;
    }

    @Override
    public ShareGroupDescribeResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ShareGroupDescribeResponseData data = new ShareGroupDescribeResponseData().setThrottleTimeMs(throttleTimeMs);
        short errorCode = Errors.forException(e).code();
        this.data.groupIds().forEach(groupId -> data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId((String)groupId).setErrorCode(errorCode)));
        return new ShareGroupDescribeResponse(data);
    }

    @Override
    public ShareGroupDescribeRequestData data() {
        return this.data;
    }

    public static ShareGroupDescribeRequest parse(Readable readable, short version, MessageContext context) {
        return new ShareGroupDescribeRequest(new ShareGroupDescribeRequestData(readable, version, context), version);
    }

    public static List<ShareGroupDescribeResponseData.DescribedGroup> getErrorDescribedGroupList(List<String> groupIds, Errors error) {
        return groupIds.stream().map(groupId -> new ShareGroupDescribeResponseData.DescribedGroup().setGroupId((String)groupId).setErrorCode(error.code())).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractRequest.Builder<ShareGroupDescribeRequest> {
        private final ShareGroupDescribeRequestData data;

        public Builder(ShareGroupDescribeRequestData data) {
            this(data, false);
        }

        public Builder(ShareGroupDescribeRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.SHARE_GROUP_DESCRIBE, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public ShareGroupDescribeRequest build(short version) {
            return new ShareGroupDescribeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

