/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareRequestMetadata;

public class ShareAcknowledgeRequest
extends AbstractRequest {
    private final ShareAcknowledgeRequestData data;

    public ShareAcknowledgeRequest(ShareAcknowledgeRequestData data, short version) {
        super(ApiKeys.SHARE_ACKNOWLEDGE, version);
        this.data = data;
    }

    @Override
    public ShareAcknowledgeRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new ShareAcknowledgeResponse(new ShareAcknowledgeResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static ShareAcknowledgeRequest parse(Readable readable, short version, MessageContext context) {
        return new ShareAcknowledgeRequest(new ShareAcknowledgeRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ShareAcknowledgeRequest> {
        private final ShareAcknowledgeRequestData data;

        public Builder(ShareAcknowledgeRequestData data) {
            this(data, false);
        }

        public Builder(ShareAcknowledgeRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.SHARE_ACKNOWLEDGE, enableUnstableLastVersion);
            this.data = data;
        }

        public static Builder forConsumer(String groupId, ShareRequestMetadata metadata, Map<TopicIdPartition, List<ShareAcknowledgeRequestData.AcknowledgementBatch>> acknowledgementsMap) {
            ShareAcknowledgeRequestData data = new ShareAcknowledgeRequestData();
            data.setGroupId(groupId);
            if (metadata != null) {
                data.setMemberId(metadata.memberId().toString());
                data.setShareSessionEpoch(metadata.epoch());
            }
            HashMap<Uuid, Map> ackMap = new HashMap<Uuid, Map>();
            for (Map.Entry<TopicIdPartition, List<ShareAcknowledgeRequestData.AcknowledgementBatch>> acknowledgeEntry : acknowledgementsMap.entrySet()) {
                TopicIdPartition tip = acknowledgeEntry.getKey();
                Map partMap2 = ackMap.computeIfAbsent(tip.topicId(), k -> new HashMap());
                ShareAcknowledgeRequestData.AcknowledgePartition ackPartition = (ShareAcknowledgeRequestData.AcknowledgePartition)partMap2.get(tip.partition());
                if (ackPartition == null) {
                    ackPartition = new ShareAcknowledgeRequestData.AcknowledgePartition().setPartitionIndex(tip.partition());
                    partMap2.put(tip.partition(), ackPartition);
                }
                ackPartition.setAcknowledgementBatches(acknowledgeEntry.getValue());
            }
            data.setTopics(new ArrayList<ShareAcknowledgeRequestData.AcknowledgeTopic>());
            ackMap.forEach((topicId, partMap) -> {
                ShareAcknowledgeRequestData.AcknowledgeTopic ackTopic = new ShareAcknowledgeRequestData.AcknowledgeTopic().setTopicId((Uuid)topicId).setPartitions(new ArrayList<ShareAcknowledgeRequestData.AcknowledgePartition>());
                data.topics().add(ackTopic);
                partMap.forEach((index, ackPartition) -> ackTopic.partitions().add((ShareAcknowledgeRequestData.AcknowledgePartition)ackPartition));
            });
            return new Builder(data, true);
        }

        public ShareAcknowledgeRequestData data() {
            return this.data;
        }

        @Override
        public ShareAcknowledgeRequest build(short version) {
            return new ShareAcknowledgeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

