/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeCellLoadResponse
extends AbstractResponse {
    private final DescribeCellLoadResponseData data;

    public DescribeCellLoadResponse(DescribeCellLoadResponseData data) {
        super(ApiKeys.DESCRIBE_CELL_LOAD);
        this.data = data;
    }

    @Override
    public DescribeCellLoadResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        DescribeCellLoadResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        return counts;
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public List<DescribeCellLoadResponseData.CellLoad> cellsLoad() {
        return this.data.cells();
    }

    public void setCellLoad(List<DescribeCellLoadResponseData.CellLoad> cellsLoad) {
        this.data.setCells(cellsLoad);
    }

    public static DescribeCellLoadResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeCellLoadResponse(new DescribeCellLoadResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

