/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class VoteRequestData
implements ApiMessage {
    String clusterId;
    int voterId;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster id."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), "The topic data."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster id."), new Field("voter_id", Type.INT32, "The replica id of the voter receiving the request."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_1), "The topic data."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster id."), new Field("voter_id", Type.INT32, "The replica id of the voter receiving the request."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_2), "The topic data."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public VoteRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public VoteRequestData() {
        this.clusterId = null;
        this.voterId = -1;
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 52;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.clusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clusterId had invalid length " + length);
            }
            this.clusterId = _readable.readString(length);
        }
        this.voterId = _version >= 1 ? _readable.readInt() : -1;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicData(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.clusterId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 1) {
            _writable.writeInt(this.voterId);
        }
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            TopicData topicsElement = (TopicData)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (_version >= 1) {
            _size.addBytes(4);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VoteRequestData)) {
            return false;
        }
        VoteRequestData other = (VoteRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.voterId != other.voterId) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.voterId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public VoteRequestData duplicate() {
        VoteRequestData _duplicate = new VoteRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.voterId = this.voterId;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "VoteRequestData(clusterId=" + (String)(this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", voterId=" + this.voterId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int voterId() {
        return this.voterId;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public VoteRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public VoteRequestData setVoterId(int v) {
        this.voterId = v;
        return this;
    }

    public VoteRequestData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class TopicData
    implements Message {
        String topicName;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), "The partition data."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_1), "The partition data."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_2), "The partition data."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.topicName = "";
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicName = this.topicName;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        int replicaEpoch;
        int replicaId;
        Uuid replicaDirectoryId;
        Uuid voterDirectoryId;
        int lastOffsetEpoch;
        long lastOffset;
        boolean preVote;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("replica_epoch", Type.INT32, "The epoch of the voter sending the request."), new Field("replica_id", Type.INT32, "The replica id of the voter sending the request."), new Field("last_offset_epoch", Type.INT32, "The epoch of the last record written to the metadata log."), new Field("last_offset", Type.INT64, "The log end offset of the metadata log of the voter sending the request."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("replica_epoch", Type.INT32, "The epoch of the voter sending the request."), new Field("replica_id", Type.INT32, "The replica id of the voter sending the request."), new Field("replica_directory_id", Type.UUID, "The directory id of the voter sending the request."), new Field("voter_directory_id", Type.UUID, "The directory id of the voter receiving the request."), new Field("last_offset_epoch", Type.INT32, "The epoch of the last record written to the metadata log."), new Field("last_offset", Type.INT64, "The log end offset of the metadata log of the voter sending the request."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("replica_epoch", Type.INT32, "The epoch of the voter sending the request."), new Field("replica_id", Type.INT32, "The replica id of the voter sending the request."), new Field("replica_directory_id", Type.UUID, "The directory id of the voter sending the request."), new Field("voter_directory_id", Type.UUID, "The directory id of the voter receiving the request."), new Field("last_offset_epoch", Type.INT32, "The epoch of the last record written to the metadata log."), new Field("last_offset", Type.INT64, "The log end offset of the metadata log of the voter sending the request."), new Field("pre_vote", Type.BOOLEAN, "Whether the request is a PreVote request (not persisted) or not."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public PartitionData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.replicaEpoch = 0;
            this.replicaId = 0;
            this.replicaDirectoryId = Uuid.ZERO_UUID;
            this.voterDirectoryId = Uuid.ZERO_UUID;
            this.lastOffsetEpoch = 0;
            this.lastOffset = 0L;
            this.preVote = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.replicaEpoch = _readable.readInt();
            this.replicaId = _readable.readInt();
            this.replicaDirectoryId = _version >= 1 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.voterDirectoryId = _version >= 1 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.lastOffsetEpoch = _readable.readInt();
            this.lastOffset = _readable.readLong();
            this.preVote = _version >= 2 ? _readable.readByte() != 0 : false;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.replicaEpoch);
            _writable.writeInt(this.replicaId);
            if (_version >= 1) {
                _writable.writeUuid(this.replicaDirectoryId);
            }
            if (_version >= 1) {
                _writable.writeUuid(this.voterDirectoryId);
            }
            _writable.writeInt(this.lastOffsetEpoch);
            _writable.writeLong(this.lastOffset);
            if (_version >= 2) {
                _writable.writeByte(this.preVote ? (byte)1 : 0);
            } else if (this.preVote) {
                throw new UnsupportedVersionException("Attempted to write a non-default preVote at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (_version >= 1) {
                _size.addBytes(16);
            }
            if (_version >= 1) {
                _size.addBytes(16);
            }
            _size.addBytes(4);
            _size.addBytes(8);
            if (_version >= 2) {
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.replicaEpoch != other.replicaEpoch) {
                return false;
            }
            if (this.replicaId != other.replicaId) {
                return false;
            }
            if (!this.replicaDirectoryId.equals(other.replicaDirectoryId)) {
                return false;
            }
            if (!this.voterDirectoryId.equals(other.voterDirectoryId)) {
                return false;
            }
            if (this.lastOffsetEpoch != other.lastOffsetEpoch) {
                return false;
            }
            if (this.lastOffset != other.lastOffset) {
                return false;
            }
            if (this.preVote != other.preVote) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.replicaEpoch;
            hashCode = 31 * hashCode + this.replicaId;
            hashCode = 31 * hashCode + this.replicaDirectoryId.hashCode();
            hashCode = 31 * hashCode + this.voterDirectoryId.hashCode();
            hashCode = 31 * hashCode + this.lastOffsetEpoch;
            hashCode = 31 * hashCode + ((int)(this.lastOffset >> 32) ^ (int)this.lastOffset);
            hashCode = 31 * hashCode + (this.preVote ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.replicaEpoch = this.replicaEpoch;
            _duplicate.replicaId = this.replicaId;
            _duplicate.replicaDirectoryId = this.replicaDirectoryId;
            _duplicate.voterDirectoryId = this.voterDirectoryId;
            _duplicate.lastOffsetEpoch = this.lastOffsetEpoch;
            _duplicate.lastOffset = this.lastOffset;
            _duplicate.preVote = this.preVote;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", replicaEpoch=" + this.replicaEpoch + ", replicaId=" + this.replicaId + ", replicaDirectoryId=" + this.replicaDirectoryId.toString() + ", voterDirectoryId=" + this.voterDirectoryId.toString() + ", lastOffsetEpoch=" + this.lastOffsetEpoch + ", lastOffset=" + this.lastOffset + ", preVote=" + (this.preVote ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int replicaEpoch() {
            return this.replicaEpoch;
        }

        public int replicaId() {
            return this.replicaId;
        }

        public Uuid replicaDirectoryId() {
            return this.replicaDirectoryId;
        }

        public Uuid voterDirectoryId() {
            return this.voterDirectoryId;
        }

        public int lastOffsetEpoch() {
            return this.lastOffsetEpoch;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public boolean preVote() {
            return this.preVote;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setReplicaEpoch(int v) {
            this.replicaEpoch = v;
            return this;
        }

        public PartitionData setReplicaId(int v) {
            this.replicaId = v;
            return this;
        }

        public PartitionData setReplicaDirectoryId(Uuid v) {
            this.replicaDirectoryId = v;
            return this;
        }

        public PartitionData setVoterDirectoryId(Uuid v) {
            this.voterDirectoryId = v;
            return this;
        }

        public PartitionData setLastOffsetEpoch(int v) {
            this.lastOffsetEpoch = v;
            return this;
        }

        public PartitionData setLastOffset(long v) {
            this.lastOffset = v;
            return this;
        }

        public PartitionData setPreVote(boolean v) {
            this.preVote = v;
            return this;
        }
    }
}

