/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.utils.Utils;

public final class AdminUtils {
    private static final int MAX_KAFKA_PROTOCOL_STRING_LENGTH = Short.MAX_VALUE;

    private AdminUtils() {
    }

    public static Set<AclOperation> validAclOperations(int authorizedOperations) {
        if (authorizedOperations == Integer.MIN_VALUE) {
            return null;
        }
        return Utils.from32BitField(authorizedOperations).stream().map(AclOperation::fromCode).filter(operation -> operation != AclOperation.UNKNOWN && operation != AclOperation.ALL && operation != AclOperation.ANY).collect(Collectors.toSet());
    }

    public static void verifyStringLengthWithinProtocolLimit(String value, String description) {
        if (value == null) {
            return;
        }
        int length = value.length();
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("%s is too long, max size is %d, provided size is %d.", description, Short.MAX_VALUE, length));
        }
    }
}

