/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.HashMap;
import org.apache.kafka.common.Uuid;

public class ProduceConsumeAuditLogTracker {
    private HashMap<TopicDetails, LoggedAuditStatus> produceAuditLogTopicTracker;
    private HashMap<TopicDetails, LoggedAuditStatus> consumeAuditLogTopicTracker;

    public Boolean hasProduceTopic(TopicDetails topicDetails) {
        this.initializeProduceAuditLogTopicTracker();
        return this.produceAuditLogTopicTracker.containsKey(topicDetails);
    }

    public Boolean hasProduceTopicWithSuccess(TopicDetails topicDetails) {
        return this.hasProduceTopic(topicDetails) != false && this.produceAuditLogTopicTracker.get(topicDetails).equals((Object)LoggedAuditStatus.SUCCESS);
    }

    public Boolean hasProduceTopicWithFailure(TopicDetails topicDetails) {
        return this.hasProduceTopic(topicDetails) != false && this.produceAuditLogTopicTracker.get(topicDetails).equals((Object)LoggedAuditStatus.FAILURE);
    }

    public int produceAuditLogTopicTrackerSize() {
        this.initializeProduceAuditLogTopicTracker();
        return this.produceAuditLogTopicTracker.size();
    }

    public Boolean hasConsumeTopic(TopicDetails topicDetails) {
        this.initializeConsumeAuditLogTopicTracker();
        return this.consumeAuditLogTopicTracker.containsKey(topicDetails);
    }

    public Boolean hasConsumeTopicWithSuccess(TopicDetails topicDetails) {
        return this.hasConsumeTopic(topicDetails) != false && this.consumeAuditLogTopicTracker.get(topicDetails).equals((Object)LoggedAuditStatus.SUCCESS);
    }

    public Boolean hasConsumeTopicWithFailures(TopicDetails topicDetails) {
        return this.hasConsumeTopic(topicDetails) != false && this.consumeAuditLogTopicTracker.get(topicDetails).equals((Object)LoggedAuditStatus.FAILURE);
    }

    public int consumeAuditLogTopicTrackerSize() {
        this.initializeConsumeAuditLogTopicTracker();
        return this.consumeAuditLogTopicTracker.size();
    }

    public void addProduceTopic(TopicDetails topicDetails, LoggedAuditStatus loggedAuditStatus) {
        this.initializeProduceAuditLogTopicTracker();
        this.produceAuditLogTopicTracker.put(topicDetails, loggedAuditStatus);
    }

    public void addConsumeTopic(TopicDetails topicDetails, LoggedAuditStatus loggedAuditStatus) {
        this.initializeConsumeAuditLogTopicTracker();
        this.consumeAuditLogTopicTracker.put(topicDetails, loggedAuditStatus);
    }

    private void initializeProduceAuditLogTopicTracker() {
        if (this.produceAuditLogTopicTracker == null) {
            this.produceAuditLogTopicTracker = new HashMap();
        }
    }

    private void initializeConsumeAuditLogTopicTracker() {
        if (this.consumeAuditLogTopicTracker == null) {
            this.consumeAuditLogTopicTracker = new HashMap();
        }
    }

    public String toString() {
        return "ProduceConsumeAuditLogTracker{produceAuditLogTopicTracker=" + this.produceAuditLogTopicTracker + ", consumeAuditLogTopicTracker=" + this.consumeAuditLogTopicTracker + '}';
    }

    public static enum LoggedAuditStatus {
        SUCCESS,
        FAILURE;

    }

    public static class TopicDetails {
        private final Uuid topicId;
        private final String topicName;

        public TopicDetails(Uuid topicId, String topicName) {
            this.topicId = topicId;
            this.topicName = topicName;
        }

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicDetails that = (TopicDetails)o;
            return this.topicId.equals(that.topicId) && this.topicName.equals(that.topicName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.topicId.hashCode();
            result = 31 * result + this.topicName.hashCode();
            return result;
        }

        public String toString() {
            return "TopicDetails{topicId=" + this.topicId + ", topicName='" + this.topicName + '\'' + '}';
        }
    }
}

