/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class MetadataResponseData
implements ApiMessage {
    int throttleTimeMs;
    MetadataResponseBrokerCollection brokers;
    String clusterId;
    int controllerId;
    MetadataResponseTopicCollection topics;
    int clusterAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_0), "A list of brokers present in the cluster."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_0), "Each topic in the response."));
    public static final Schema SCHEMA_1 = new Schema(new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "A list of brokers present in the cluster."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_1), "Each topic in the response."));
    public static final Schema SCHEMA_2 = new Schema(new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "A list of brokers present in the cluster."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_1), "Each topic in the response."));
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema SCHEMA_12;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 12;

    public MetadataResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public MetadataResponseData() {
        this.throttleTimeMs = 0;
        this.brokers = new MetadataResponseBrokerCollection(0);
        this.clusterId = null;
        this.controllerId = -1;
        this.topics = new MetadataResponseTopicCollection(0);
        this.clusterAuthorizedOperations = Integer.MIN_VALUE;
    }

    @Override
    public short apiKey() {
        return 3;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 12;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ImplicitLinkedHashMultiCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 3 ? _readable.readInt() : 0;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new MetadataResponseBrokerCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new MetadataResponseBroker(_readable, _version, _context));
            }
            this.brokers = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new MetadataResponseBrokerCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new MetadataResponseBroker(_readable, _version, _context));
            }
            this.brokers = newCollection;
        }
        if (_version >= 2) {
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.clusterId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field clusterId had invalid length " + length);
                }
                this.clusterId = _context.read(EntityType.CLUSTER_ID, _readable.readString(length));
            }
        } else {
            this.clusterId = null;
        }
        this.controllerId = _version >= 1 ? _readable.readInt() : -1;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new MetadataResponseTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new MetadataResponseTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new MetadataResponseTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new MetadataResponseTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        this.clusterAuthorizedOperations = _version >= 8 && _version <= 10 ? _readable.readInt() : Integer.MIN_VALUE;
        this._unknownTaggedFields = null;
        if (_version >= 9) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        MetadataResponseTopic topicsElement;
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 9) {
            _writable.writeUnsignedVarint(this.brokers.size() + 1);
            for (MetadataResponseBroker brokersElement : this.brokers) {
                brokersElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.brokers.size());
            for (MetadataResponseBroker brokersElement : this.brokers) {
                brokersElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 2) {
            if (this.clusterId == null) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.clusterId);
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
        }
        if (_version >= 1) {
            _writable.writeInt(this.controllerId);
        }
        if (_version >= 9) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                topicsElement = (MetadataResponseTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.topics.size());
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                topicsElement = (MetadataResponseTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 8 && _version <= 10) {
            _writable.writeInt(this.clusterAuthorizedOperations);
        } else if (this.clusterAuthorizedOperations != Integer.MIN_VALUE) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterAuthorizedOperations at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 9) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _size.addBytes(4);
        }
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokers.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (MetadataResponseBroker brokersElement : this.brokers) {
            brokersElement.addSize(_size, _cache, _version, _context);
        }
        if (_version >= 2) {
            if (this.clusterId == null) {
                if (_version >= 9) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = _context.write(EntityType.CLUSTER_ID, this.clusterId).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterId, _stringBytes);
                if (_version >= 9) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
        }
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (MetadataResponseTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (_version >= 8 && _version <= 10) {
            _size.addBytes(4);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataResponseData)) {
            return false;
        }
        MetadataResponseData other = (MetadataResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.brokers == null ? other.brokers != null : !this.brokers.equals(other.brokers)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.clusterAuthorizedOperations != other.clusterAuthorizedOperations) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.clusterAuthorizedOperations;
        return hashCode;
    }

    @Override
    public MetadataResponseData duplicate() {
        MetadataResponseData _duplicate = new MetadataResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        MetadataResponseBrokerCollection newBrokers = new MetadataResponseBrokerCollection(this.brokers.size());
        for (MetadataResponseBroker _element : this.brokers) {
            newBrokers.add(_element.duplicate());
        }
        _duplicate.brokers = newBrokers;
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.controllerId = this.controllerId;
        MetadataResponseTopicCollection newTopics = new MetadataResponseTopicCollection(this.topics.size());
        for (MetadataResponseTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.clusterAuthorizedOperations = this.clusterAuthorizedOperations;
        return _duplicate;
    }

    public String toString() {
        return "MetadataResponseData(throttleTimeMs=" + this.throttleTimeMs + ", brokers=" + MessageUtil.deepToString(this.brokers.iterator()) + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", controllerId=" + this.controllerId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", clusterAuthorizedOperations=" + this.clusterAuthorizedOperations + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public MetadataResponseBrokerCollection brokers() {
        return this.brokers;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public MetadataResponseTopicCollection topics() {
        return this.topics;
    }

    public int clusterAuthorizedOperations() {
        return this.clusterAuthorizedOperations;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MetadataResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public MetadataResponseData setBrokers(MetadataResponseBrokerCollection v) {
        this.brokers = v;
        return this;
    }

    public MetadataResponseData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public MetadataResponseData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public MetadataResponseData setTopics(MetadataResponseTopicCollection v) {
        this.topics = v;
        return this;
    }

    public MetadataResponseData setClusterAuthorizedOperations(int v) {
        this.clusterAuthorizedOperations = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "A list of brokers present in the cluster."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_1), "Each topic in the response."));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "A list of brokers present in the cluster."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_5), "Each topic in the response."));
        SCHEMA_7 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "A list of brokers present in the cluster."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_7), "Each topic in the response."));
        SCHEMA_8 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new ArrayOf(MetadataResponseBroker.SCHEMA_1), "A list of brokers present in the cluster."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new ArrayOf(MetadataResponseTopic.SCHEMA_8), "Each topic in the response."), new Field("cluster_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this cluster."));
        SCHEMA_9 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new CompactArrayOf(MetadataResponseBroker.SCHEMA_9), "A list of brokers present in the cluster."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new CompactArrayOf(MetadataResponseTopic.SCHEMA_9), "Each topic in the response."), new Field("cluster_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this cluster."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_10 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new CompactArrayOf(MetadataResponseBroker.SCHEMA_9), "A list of brokers present in the cluster."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new CompactArrayOf(MetadataResponseTopic.SCHEMA_10), "Each topic in the response."), new Field("cluster_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this cluster."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_11 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new CompactArrayOf(MetadataResponseBroker.SCHEMA_9), "A list of brokers present in the cluster."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new CompactArrayOf(MetadataResponseTopic.SCHEMA_10), "Each topic in the response."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_12 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("brokers", new CompactArrayOf(MetadataResponseBroker.SCHEMA_9), "A list of brokers present in the cluster."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", Type.INT32, "The ID of the controller broker."), new Field("topics", new CompactArrayOf(MetadataResponseTopic.SCHEMA_12), "Each topic in the response."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
    }

    public static class MetadataResponseTopicCollection
    extends ImplicitLinkedHashMultiCollection<MetadataResponseTopic> {
        public MetadataResponseTopicCollection() {
        }

        public MetadataResponseTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public MetadataResponseTopicCollection(Iterator<MetadataResponseTopic> iterator) {
            super(iterator);
        }

        @Override
        public MetadataResponseTopic find(String name) {
            MetadataResponseTopic _key = new MetadataResponseTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<MetadataResponseTopic> findAll(String name) {
            MetadataResponseTopic _key = new MetadataResponseTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public MetadataResponseTopicCollection duplicate() {
            MetadataResponseTopicCollection _duplicate = new MetadataResponseTopicCollection(this.size());
            for (MetadataResponseTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class MetadataResponsePartition
    implements Message {
        short errorCode;
        int partitionIndex;
        int leaderId;
        int leaderEpoch;
        List<Integer> replicaNodes;
        List<Integer> observers;
        List<Integer> isrNodes;
        List<Integer> offlineReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public MetadataResponsePartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MetadataResponsePartition() {
            this.errorCode = 0;
            this.partitionIndex = 0;
            this.leaderId = 0;
            this.leaderEpoch = -1;
            this.replicaNodes = new ArrayList<Integer>(0);
            this.observers = new ArrayList<Integer>(0);
            this.isrNodes = new ArrayList<Integer>(0);
            this.offlineReplicas = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponsePartition");
            }
            this.errorCode = _readable.readShort();
            this.partitionIndex = _readable.readInt();
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _version >= 7 ? _readable.readInt() : -1;
            int arrayLength = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaNodes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicaNodes = newCollection;
            this.observers = new ArrayList<Integer>(0);
            arrayLength = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isrNodes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isrNodes = newCollection;
            if (_version >= 5) {
                arrayLength = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field offlineReplicas was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.offlineReplicas = newCollection;
            } else {
                this.offlineReplicas = new ArrayList<Integer>(0);
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block6: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int arrayLength2 = _readable.readUnsignedVarint() - 1;
                            if (arrayLength2 < 0) {
                                throw new RuntimeException("non-nullable field observers was serialized as null");
                            }
                            if (arrayLength2 > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            ArrayList<Integer> newCollection2 = new ArrayList<Integer>(arrayLength2);
                            for (int i2 = 0; i2 < arrayLength2; ++i2) {
                                newCollection2.add(_readable.readInt());
                            }
                            this.observers = newCollection2;
                            continue block6;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.leaderId);
            if (_version >= 7) {
                _writable.writeInt(this.leaderEpoch);
            }
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.replicaNodes.size() + 1);
            } else {
                _writable.writeInt(this.replicaNodes.size());
            }
            for (Integer replicaNodesElement : this.replicaNodes) {
                _writable.writeInt(replicaNodesElement);
            }
            if (_version >= 9 && !this.observers.isEmpty()) {
                ++_numTaggedFields;
            }
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.isrNodes.size() + 1);
            } else {
                _writable.writeInt(this.isrNodes.size());
            }
            for (Integer isrNodesElement : this.isrNodes) {
                _writable.writeInt(isrNodesElement);
            }
            if (_version >= 5) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(this.offlineReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.offlineReplicas.size());
                }
                for (Integer offlineReplicasElement : this.offlineReplicas) {
                    _writable.writeInt(offlineReplicasElement);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.observers.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers));
                    _writable.writeUnsignedVarint(this.observers.size() + 1);
                    for (Integer observersElement : this.observers) {
                        _writable.writeInt(observersElement);
                    }
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataResponsePartition");
            }
            _size.addBytes(2);
            _size.addBytes(4);
            _size.addBytes(4);
            if (_version >= 7) {
                _size.addBytes(4);
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.replicaNodes.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.replicaNodes.size() * 4);
            if (_version >= 9 && !this.observers.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.observers.size() + 1));
                _size.addBytes(this.observers.size() * 4);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.observers, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.isrNodes.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.isrNodes.size() * 4);
            if (_version >= 5) {
                if (_version >= 9) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.offlineReplicas.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                _size.addBytes(this.offlineReplicas.size() * 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponsePartition)) {
                return false;
            }
            MetadataResponsePartition other = (MetadataResponsePartition)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.replicaNodes == null ? other.replicaNodes != null : !this.replicaNodes.equals(other.replicaNodes)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            if (this.isrNodes == null ? other.isrNodes != null : !this.isrNodes.equals(other.isrNodes)) {
                return false;
            }
            if (this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.replicaNodes == null ? 0 : this.replicaNodes.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            hashCode = 31 * hashCode + (this.isrNodes == null ? 0 : this.isrNodes.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        @Override
        public MetadataResponsePartition duplicate() {
            MetadataResponsePartition _duplicate = new MetadataResponsePartition();
            _duplicate.errorCode = this.errorCode;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newReplicaNodes = new ArrayList<Integer>(this.replicaNodes.size());
            for (Integer n : this.replicaNodes) {
                newReplicaNodes.add(n);
            }
            _duplicate.replicaNodes = newReplicaNodes;
            ArrayList<Integer> newObservers = new ArrayList<Integer>(this.observers.size());
            for (Integer n : this.observers) {
                newObservers.add(n);
            }
            _duplicate.observers = newObservers;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.isrNodes.size());
            for (Integer _element : this.isrNodes) {
                arrayList.add(_element);
            }
            _duplicate.isrNodes = arrayList;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.offlineReplicas.size());
            for (Integer _element : this.offlineReplicas) {
                arrayList2.add(_element);
            }
            _duplicate.offlineReplicas = arrayList2;
            return _duplicate;
        }

        public String toString() {
            return "MetadataResponsePartition(errorCode=" + this.errorCode + ", partitionIndex=" + this.partitionIndex + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", replicaNodes=" + MessageUtil.deepToString(this.replicaNodes.iterator()) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ", isrNodes=" + MessageUtil.deepToString(this.isrNodes.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> replicaNodes() {
            return this.replicaNodes;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<Integer> isrNodes() {
            return this.isrNodes;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MetadataResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public MetadataResponsePartition setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public MetadataResponsePartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public MetadataResponsePartition setReplicaNodes(List<Integer> v) {
            this.replicaNodes = v;
            return this;
        }

        public MetadataResponsePartition setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }

        public MetadataResponsePartition setIsrNodes(List<Integer> v) {
            this.isrNodes = v;
            return this;
        }

        public MetadataResponsePartition setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("replica_nodes", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition.")))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("replica_nodes", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The set of offline replicas of this partition."));
            SCHEMA_8 = SCHEMA_7 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("replica_nodes", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The set of offline replicas of this partition."));
            SCHEMA_12 = SCHEMA_11 = (SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("error_code", Type.INT16, "The partition error, or 0 if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_id", Type.INT32, "The ID of the leader broker."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("replica_nodes", new CompactArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr_nodes", new CompactArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", new CompactArrayOf(Type.INT32), "The set of offline replicas of this partition."), Field.TaggedFieldsSection.of(10000, new Field("observers", new CompactArrayOf(Type.INT32), "The brokers in ReplicaNodes that are observers in a partition.")))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }

    public static class MetadataResponseTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        short errorCode;
        String name;
        Uuid topicId;
        boolean isInternal;
        List<MetadataResponsePartition> partitions;
        int topicAuthorizedOperations;
        byte topicType;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_0), "Each partition in the topic."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public MetadataResponseTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public MetadataResponseTopic() {
            this.errorCode = 0;
            this.name = "";
            this.topicId = Uuid.ZERO_UUID;
            this.isInternal = false;
            this.partitions = new ArrayList<MetadataResponsePartition>(0);
            this.topicAuthorizedOperations = Integer.MIN_VALUE;
            this.topicType = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<MetadataResponsePartition> newCollection;
            int arrayLength;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponseTopic");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                if (_version < 12) throw new RuntimeException("non-nullable field name was serialized as null");
                this.name = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field name had invalid length " + length);
                }
                this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            }
            this.topicId = _version >= 10 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.isInternal = _version >= 1 ? _readable.readByte() != 0 : false;
            if (_version >= 9) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataResponsePartition(_readable, _version, _context));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<MetadataResponsePartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataResponsePartition(_readable, _version, _context));
                }
                this.partitions = newCollection;
            }
            this.topicAuthorizedOperations = _version >= 8 ? _readable.readInt() : Integer.MIN_VALUE;
            this.topicType = 0;
            this._unknownTaggedFields = null;
            if (_version < 9) return;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        if (_version < 12) throw new RuntimeException("Tag 10000 is not valid for version " + _version);
                        this.topicType = _readable.readByte();
                        continue block5;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.name == null) {
                if (_version < 12) throw new NullPointerException();
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.name);
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 10) {
                _writable.writeUuid(this.topicId);
            }
            if (_version >= 1) {
                _writable.writeByte(this.isInternal ? (byte)1 : 0);
            }
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    MetadataResponsePartition partitionsElement = (MetadataResponsePartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    MetadataResponsePartition partitionsElement = (MetadataResponsePartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 8) {
                _writable.writeInt(this.topicAuthorizedOperations);
            } else if (this.topicAuthorizedOperations != Integer.MIN_VALUE) {
                throw new UnsupportedVersionException("Attempted to write a non-default topicAuthorizedOperations at version " + _version);
            }
            if (_version >= 12 && this.topicType != 0) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (_version >= 12 && this.topicType != 0) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(1);
                    _writable.writeByte(this.topicType);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
                return;
            } else {
                if (_numTaggedFields <= 0) return;
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataResponseTopic");
            }
            _size.addBytes(2);
            if (this.name == null) {
                if (_version >= 9) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'name' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.name, _stringBytes);
                if (_version >= 9) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 10) {
                _size.addBytes(16);
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (MetadataResponsePartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (_version >= 8) {
                _size.addBytes(4);
            }
            if (_version >= 12 && this.topicType != 0) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof MetadataResponseTopic)) {
                return false;
            }
            MetadataResponseTopic other = (MetadataResponseTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponseTopic)) {
                return false;
            }
            MetadataResponseTopic other = (MetadataResponseTopic)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.isInternal != other.isInternal) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            if (this.topicAuthorizedOperations != other.topicAuthorizedOperations) {
                return false;
            }
            if (this.topicType != other.topicType) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public MetadataResponseTopic duplicate() {
            MetadataResponseTopic _duplicate = new MetadataResponseTopic();
            _duplicate.errorCode = this.errorCode;
            _duplicate.name = this.name == null ? null : this.name;
            _duplicate.topicId = this.topicId;
            _duplicate.isInternal = this.isInternal;
            ArrayList<MetadataResponsePartition> newPartitions = new ArrayList<MetadataResponsePartition>(this.partitions.size());
            for (MetadataResponsePartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            _duplicate.topicAuthorizedOperations = this.topicAuthorizedOperations;
            _duplicate.topicType = this.topicType;
            return _duplicate;
        }

        public String toString() {
            return "MetadataResponseTopic(errorCode=" + this.errorCode + ", name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", topicId=" + this.topicId.toString() + ", isInternal=" + (this.isInternal ? "true" : "false") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ", topicAuthorizedOperations=" + this.topicAuthorizedOperations + ", topicType=" + this.topicType + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String name() {
            return this.name;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<MetadataResponsePartition> partitions() {
            return this.partitions;
        }

        public int topicAuthorizedOperations() {
            return this.topicAuthorizedOperations;
        }

        public byte topicType() {
            return this.topicType;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataResponseTopic setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MetadataResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public MetadataResponseTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public MetadataResponseTopic setIsInternal(boolean v) {
            this.isInternal = v;
            return this;
        }

        public MetadataResponseTopic setPartitions(List<MetadataResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        public MetadataResponseTopic setTopicAuthorizedOperations(int v) {
            this.topicAuthorizedOperations = v;
            return this;
        }

        public MetadataResponseTopic setTopicType(byte v) {
            this.topicType = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_0), "Each partition in the topic."))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_5), "Each partition in the topic."));
            SCHEMA_7 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_7), "Each partition in the topic."));
            SCHEMA_8 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new ArrayOf(MetadataResponsePartition.SCHEMA_7), "Each partition in the topic."), new Field("topic_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this topic."));
            SCHEMA_9 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.COMPACT_STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new CompactArrayOf(MetadataResponsePartition.SCHEMA_9), "Each partition in the topic."), new Field("topic_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_11 = SCHEMA_10 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.COMPACT_STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("topic_id", Type.UUID, "The topic id. Zero for non-existing topics queried by name. This is never zero when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new CompactArrayOf(MetadataResponsePartition.SCHEMA_9), "Each partition in the topic."), new Field("topic_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_12 = new Schema(new Field("error_code", Type.INT16, "The topic error, or 0 if there was no error."), new Field("name", Type.COMPACT_NULLABLE_STRING, "The topic name. Null for non-existing topics queried by ID. This is never null when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("topic_id", Type.UUID, "The topic id. Zero for non-existing topics queried by name. This is never zero when ErrorCode is zero. One of Name and TopicId is always populated."), new Field("is_internal", Type.BOOLEAN, "True if the topic is internal."), new Field("partitions", new CompactArrayOf(MetadataResponsePartition.SCHEMA_9), "Each partition in the topic."), new Field("topic_authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this topic."), Field.TaggedFieldsSection.of(10000, new Field("topic_type", Type.INT8, "The topic type. (STANDARD=0, FREIGHT=1, VIRTUAL=2)")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }

    public static class MetadataResponseBrokerCollection
    extends ImplicitLinkedHashMultiCollection<MetadataResponseBroker> {
        public MetadataResponseBrokerCollection() {
        }

        public MetadataResponseBrokerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public MetadataResponseBrokerCollection(Iterator<MetadataResponseBroker> iterator) {
            super(iterator);
        }

        @Override
        public MetadataResponseBroker find(int nodeId) {
            MetadataResponseBroker _key = new MetadataResponseBroker();
            _key.setNodeId(nodeId);
            return this.find(_key);
        }

        @Override
        public List<MetadataResponseBroker> findAll(int nodeId) {
            MetadataResponseBroker _key = new MetadataResponseBroker();
            _key.setNodeId(nodeId);
            return this.findAll(_key);
        }

        public MetadataResponseBrokerCollection duplicate() {
            MetadataResponseBrokerCollection _duplicate = new MetadataResponseBrokerCollection(this.size());
            for (MetadataResponseBroker _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class MetadataResponseBroker
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int nodeId;
        String host;
        int port;
        String rack;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("node_id", Type.INT32, "The broker ID."), new Field("host", Type.STRING, "The broker hostname."), new Field("port", Type.INT32, "The broker port."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public MetadataResponseBroker(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public MetadataResponseBroker() {
            this.nodeId = 0;
            this.host = "";
            this.port = 0;
            this.rack = null;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataResponseBroker");
            }
            this.nodeId = _readable.readInt();
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readInt();
            if (_version >= 1) {
                length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.rack = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field rack had invalid length " + length);
                    }
                    this.rack = _readable.readString(length);
                }
            } else {
                this.rack = null;
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.nodeId);
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            if (_version >= 1) {
                if (this.rack == null) {
                    if (_version >= 9) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue(this.rack);
                    if (_version >= 9) {
                        _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    } else {
                        _writable.writeShort((short)_stringBytes.length);
                    }
                    _writable.writeByteArray(_stringBytes);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataResponseBroker");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            if (_version >= 9) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(4);
            if (_version >= 1) {
                if (this.rack == null) {
                    if (_version >= 9) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(2);
                    }
                } else {
                    _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'rack' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.rack, _stringBytes);
                    if (_version >= 9) {
                        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                    } else {
                        _size.addBytes(_stringBytes.length + 2);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof MetadataResponseBroker)) {
                return false;
            }
            MetadataResponseBroker other = (MetadataResponseBroker)obj;
            return this.nodeId == other.nodeId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataResponseBroker)) {
                return false;
            }
            MetadataResponseBroker other = (MetadataResponseBroker)obj;
            if (this.nodeId != other.nodeId) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.nodeId;
            return hashCode;
        }

        @Override
        public MetadataResponseBroker duplicate() {
            MetadataResponseBroker _duplicate = new MetadataResponseBroker();
            _duplicate.nodeId = this.nodeId;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.rack = this.rack == null ? null : this.rack;
            return _duplicate;
        }

        public String toString() {
            return "MetadataResponseBroker(nodeId=" + this.nodeId + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ")";
        }

        public int nodeId() {
            return this.nodeId;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String rack() {
            return this.rack;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataResponseBroker setNodeId(int v) {
            this.nodeId = v;
            return this;
        }

        public MetadataResponseBroker setHost(String v) {
            this.host = v;
            return this;
        }

        public MetadataResponseBroker setPort(int v) {
            this.port = v;
            return this;
        }

        public MetadataResponseBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("node_id", Type.INT32, "The broker ID."), new Field("host", Type.STRING, "The broker hostname."), new Field("port", Type.INT32, "The broker port."), new Field("rack", Type.NULLABLE_STRING, "The rack of the broker, or null if it has not been assigned to a rack."))))))));
            SCHEMA_12 = SCHEMA_11 = (SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("node_id", Type.INT32, "The broker ID."), new Field("host", Type.COMPACT_STRING, "The broker hostname."), new Field("port", Type.INT32, "The broker port."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack of the broker, or null if it has not been assigned to a rack."), Field.TaggedFieldsSection.of(new Object[0]))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }
}

