/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.BasicOAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ClaimValidationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.SerializedJwt;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginAccessTokenValidator
implements AccessTokenValidator {
    private static final Logger log = LoggerFactory.getLogger(LoginAccessTokenValidator.class);
    public static final String EXPIRATION_CLAIM_NAME = "exp";
    public static final String ISSUED_AT_CLAIM_NAME = "iat";
    private final String scopeClaimName;
    private final String subClaimName;

    public LoginAccessTokenValidator(String scopeClaimName, String subClaimName) {
        this.scopeClaimName = ClaimValidationUtils.validateClaimNameOverride("scope", scopeClaimName);
        this.subClaimName = ClaimValidationUtils.validateClaimNameOverride("sub", subClaimName);
    }

    @Override
    public OAuthBearerToken validate(String accessToken) throws ValidateException {
        Map<String, Object> payload;
        SerializedJwt serializedJwt = new SerializedJwt(accessToken);
        try {
            payload = OAuthBearerUnsecuredJws.toMap(serializedJwt.getPayload());
        }
        catch (OAuthBearerIllegalTokenException e) {
            throw new ValidateException(String.format("Could not validate the access token: %s", e.getMessage()), e);
        }
        Object scopeRaw = this.getClaim(payload, this.scopeClaimName);
        Collection<Object> scopeRawCollection = scopeRaw instanceof String ? Collections.singletonList((String)scopeRaw) : (scopeRaw instanceof Collection ? (Collection)scopeRaw : Collections.emptySet());
        Number expirationRaw = (Number)this.getClaim(payload, EXPIRATION_CLAIM_NAME);
        String subRaw = (String)this.getClaim(payload, this.subClaimName);
        Number issuedAtRaw = (Number)this.getClaim(payload, ISSUED_AT_CLAIM_NAME);
        Set<String> scopes = ClaimValidationUtils.validateScopes(this.scopeClaimName, scopeRawCollection);
        long expiration = ClaimValidationUtils.validateExpiration(EXPIRATION_CLAIM_NAME, expirationRaw != null ? Long.valueOf(expirationRaw.longValue() * 1000L) : null);
        String subject = ClaimValidationUtils.validateSubject(this.subClaimName, subRaw);
        Long issuedAt = ClaimValidationUtils.validateIssuedAt(ISSUED_AT_CLAIM_NAME, issuedAtRaw != null ? Long.valueOf(issuedAtRaw.longValue() * 1000L) : null);
        return new BasicOAuthBearerToken(accessToken, scopes, expiration, subject, issuedAt);
    }

    private Object getClaim(Map<String, Object> payload, String claimName) {
        Object value = payload.getOrDefault(claimName, null);
        log.debug("getClaim - {}: {}", (Object)claimName, value);
        return value;
    }
}

