/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.message.DescribeMirrorsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;

public class DescribeMirrorsRequest
extends AbstractRequest {
    public static final short OLDEST_ALLOWED_VERSION_LINK_COORDINATOR_HANDLING = 6;
    private final DescribeMirrorsRequestData data;

    public DescribeMirrorsRequest(DescribeMirrorsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_MIRRORS, version);
        this.data = data;
    }

    public Collection<String> topics() {
        return this.data.topics();
    }

    public boolean includeTransitionErrors() {
        return this.data.includeStateTransitionErrors();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public DescribeMirrorsRequestData data() {
        return this.data;
    }

    @Override
    public DescribeMirrorsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeMirrorsResponse(this.data.topics(), throttleTimeMs, e);
    }

    public static DescribeMirrorsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeMirrorsRequest(new DescribeMirrorsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeMirrorsRequest> {
        private final DescribeMirrorsRequestData data;

        public Builder(Collection<String> topics, Collection<String> linkNames, Collection<String> states, int timeoutMs) {
            super(ApiKeys.DESCRIBE_MIRRORS);
            this.data = new DescribeMirrorsRequestData().setTopics(new ArrayList<String>(topics)).setTimeoutMs(timeoutMs).setLinkNames(new ArrayList<String>(linkNames)).setStates(new ArrayList<String>(states));
        }

        public Builder(Collection<String> topics, Collection<String> linkNames, Collection<String> states, int timeoutMs, boolean includeTransitionErrors, short oldestAllowedVersion, short newestAllowedVersion) {
            super(ApiKeys.DESCRIBE_MIRRORS, oldestAllowedVersion, newestAllowedVersion);
            this.data = new DescribeMirrorsRequestData().setTopics(new ArrayList<String>(topics)).setTimeoutMs(timeoutMs).setLinkNames(new ArrayList<String>(linkNames)).setStates(new ArrayList<String>(states)).setIncludeStateTransitionErrors(includeTransitionErrors);
        }

        @Override
        public DescribeMirrorsRequest build(short version) {
            return new DescribeMirrorsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

