/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DescribeBrokerHealthRequestData;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;

public class DescribeBrokerHealthRequest
extends AbstractRequest {
    private final DescribeBrokerHealthRequestData data;

    public DescribeBrokerHealthRequest(DescribeBrokerHealthRequestData data, short apiVersion) {
        super(ApiKeys.DESCRIBE_BROKER_HEALTH, apiVersion);
        this.data = data;
    }

    @Override
    public DescribeBrokerHealthRequestData data() {
        return this.data;
    }

    @Override
    public DescribeBrokerHealthResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        DescribeBrokerHealthResponseData responseData = new DescribeBrokerHealthResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new DescribeBrokerHealthResponse(responseData);
    }

    public static DescribeBrokerHealthRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeBrokerHealthRequest(new DescribeBrokerHealthRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeBrokerHealthRequest> {
        private final DescribeBrokerHealthRequestData data = new DescribeBrokerHealthRequestData();

        public Builder() {
            super(ApiKeys.DESCRIBE_BROKER_HEALTH);
        }

        public Builder(short oldestAllowedVersion) {
            super(ApiKeys.DESCRIBE_BROKER_HEALTH, oldestAllowedVersion, ApiKeys.DESCRIBE_BROKER_HEALTH.latestVersion());
        }

        public Builder(short oldestAllowedVersion, short newestAllowedVersion) {
            super(ApiKeys.DESCRIBE_BROKER_HEALTH, oldestAllowedVersion, newestAllowedVersion);
        }

        @Override
        public DescribeBrokerHealthRequest build(short version) {
            return new DescribeBrokerHealthRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

