/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.quota;

import java.util.Collection;
import java.util.Objects;
import org.apache.kafka.common.quota.ClientQuotaEntity;

public class ClientQuotaAlteration {
    private final ClientQuotaEntity entity;
    private final Collection<Op> ops;

    public ClientQuotaAlteration(ClientQuotaEntity entity, Collection<Op> ops) {
        this.entity = entity;
        this.ops = ops;
    }

    public ClientQuotaEntity entity() {
        return this.entity;
    }

    public Collection<Op> ops() {
        return this.ops;
    }

    public String toString() {
        return "ClientQuotaAlteration(entity=" + this.entity + ", ops=" + this.ops + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQuotaAlteration that = (ClientQuotaAlteration)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.ops, that.ops);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.entity);
        result = 31 * result + Objects.hashCode(this.ops);
        return result;
    }

    public static class Op {
        private final String key;
        private final Double value;

        public Op(String key, Double value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public Double value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Op that = (Op)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "ClientQuotaAlteration.Op(key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

