/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Optional;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvType;
import org.apache.kafka.common.network.TransportLayer;

public abstract class AbstractTransportLayer
implements TransportLayer {
    protected SelectionKey key;
    protected final SocketChannel socketChannel;
    protected final ProxyProtocolEngine proxyProtocolEngine;
    protected ByteBuffer netReadBuffer;
    protected String lkcId;
    private boolean lkcParsed;
    private boolean proxyModeLocalDefault;

    public AbstractTransportLayer(SelectionKey key, ProxyProtocolEngine proxyProtocolEngine) {
        this(key, proxyProtocolEngine, false);
    }

    public AbstractTransportLayer(SelectionKey key, ProxyProtocolEngine proxyProtocolEngine, boolean proxyModeLocalDefault) {
        this.key = key;
        this.socketChannel = (SocketChannel)key.channel();
        this.proxyProtocolEngine = proxyProtocolEngine;
        this.proxyModeLocalDefault = proxyModeLocalDefault;
    }

    @Override
    public boolean finishConnect() throws IOException {
        boolean connected = this.socketChannel.finishConnect();
        if (connected) {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFF7 | 1);
        }
        return connected;
    }

    @Override
    public void disconnect() {
        this.key.cancel();
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public SelectionKey selectionKey() {
        return this.key;
    }

    @Override
    public InetAddress socketAddress() {
        if (this.proxyProtocolEngine.ready() && this.proxyProtocolEngine.hasClientInformation()) {
            return this.proxyProtocolEngine.clientAddress();
        }
        return this.socketChannel.socket().getInetAddress();
    }

    @Override
    public boolean isProxyModeLocal() {
        if (this.proxyProtocolEngine.command() == null) {
            return this.proxyModeLocalDefault;
        }
        return this.proxyProtocolEngine.command() == ProxyProtocolCommand.LOCAL;
    }

    protected int readFromSocketChannel() throws IOException {
        return this.socketChannel.read(this.netReadBuffer);
    }

    protected int maybeReadAndProcessProxyHeaders() throws IOException {
        int read = 0;
        if (!this.proxyProtocolReady() && this.key.isReadable()) {
            read = this.readFromSocketChannel();
            if (read < 0) {
                throw new EOFException("EOF while reading PROXY headers");
            }
            this.netReadBuffer.flip();
            this.proxyProtocolEngine.processHeaders(this.netReadBuffer);
            this.netReadBuffer.compact();
        }
        return read;
    }

    @Override
    public boolean proxyProtocolReady() {
        return this.proxyProtocolEngine.ready();
    }

    @Override
    public ProxyTlv tlv(ProxyTlvType type) {
        return this.proxyProtocolEngine.tlv(type);
    }

    @Override
    public String socketDescription() {
        InetAddress address = this.socketAddress();
        return address != null ? address.toString() : this.socketChannel.socket().getLocalAddress().toString();
    }

    @Override
    public Optional<String> lkcId() {
        if (!this.lkcParsed && this.proxyProtocolReady()) {
            ProxyTlv tlv = this.proxyProtocolEngine.tlv(ProxyTlvType.LKC_ID);
            if (tlv != null) {
                this.lkcId = ProxyTlvType.lkcString(tlv.value);
            }
            this.lkcParsed = true;
        }
        return Optional.ofNullable(this.lkcId);
    }
}

