/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public abstract class AbstractProxyProtocolEngine
implements ProxyProtocolEngine {
    protected final ConnectionMode connectionMode;
    protected final Logger log;
    protected boolean proxyProtocolFallbackEnabled = false;
    protected boolean proxyHeaderProcessed = false;
    protected InetAddress sourceAddress;
    protected int sourcePort = -1;

    protected AbstractProxyProtocolEngine(ConnectionMode connectionMode, LogContext logContext) {
        this.connectionMode = connectionMode;
        this.log = logContext.logger(this.getClass());
    }

    @Override
    public boolean hasClientInformation() {
        return this.sourceAddress != null;
    }

    @Override
    public InetAddress clientAddress() {
        return this.sourceAddress;
    }

    @Override
    public int clientPort() {
        return this.sourcePort;
    }

    @Override
    public boolean ready() {
        return this.proxyHeaderProcessed;
    }

    @Override
    public ConnectionMode connectionMode() {
        return this.connectionMode;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        Map<String, Object> configMap = Collections.unmodifiableMap(configs);
        if (this.connectionMode == ConnectionMode.SERVER) {
            this.configureServer(configMap);
        } else if (this.connectionMode == ConnectionMode.CLIENT) {
            this.configureClient(configMap);
        } else {
            this.log.warn("The proxy protocol engine was not configured because mode: {}", (Object)this.connectionMode);
        }
    }

    protected void configureServer(Map<String, Object> configMap) {
        this.proxyProtocolFallbackEnabled = (Boolean)configMap.getOrDefault("confluent.proxy.protocol.fallback.enabled", ConfluentConfigs.PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT);
        this.log.debug("The proxy protocol engine was configured with {}: {}", (Object)"confluent.proxy.protocol.fallback.enabled", (Object)this.proxyProtocolFallbackEnabled);
    }

    protected void configureClient(Map<String, Object> configs) {
        this.sourceAddress = AbstractProxyProtocolEngine.getConfiguredSourceAddress(configs);
        this.sourcePort = AbstractProxyProtocolEngine.getConfiguredSourcePort(configs);
        this.log.debug("The proxy protocol engine was configured with {}: {}, {}: {}", new Object[]{"confluent.proxy.protocol.client.address", this.sourceAddress, "confluent.proxy.protocol.client.port", this.sourcePort});
    }

    protected static String getConfiguredString(Map<String, Object> configs, String configName) {
        String s = (String)configs.get(configName);
        if (Utils.isBlank(s)) {
            throw AbstractProxyProtocolEngine.newConfigException(configName);
        }
        return s;
    }

    protected static int getConfiguredInt(Map<String, Object> configs, String configName) {
        if (configs.get(configName) == null) {
            throw AbstractProxyProtocolEngine.newConfigException(configName);
        }
        return (Integer)configs.get(configName);
    }

    protected static InetAddress getConfiguredSourceAddress(Map<String, Object> configs) {
        String addr = AbstractProxyProtocolEngine.getConfiguredString(configs, "confluent.proxy.protocol.client.address");
        try {
            return InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            throw AbstractProxyProtocolEngine.newConfigException("confluent.proxy.protocol.client.address", addr);
        }
    }

    protected static Integer getConfiguredSourcePort(Map<String, Object> configs) {
        int port = AbstractProxyProtocolEngine.getConfiguredInt(configs, "confluent.proxy.protocol.client.port");
        if (AbstractProxyProtocolEngine.isPortInvalid(port)) {
            throw AbstractProxyProtocolEngine.newConfigException("confluent.proxy.protocol.client.address", port);
        }
        return port;
    }

    protected static ConfigException newConfigException(String configName) {
        return new ConfigException(String.format("The required configuration %s was not present", configName));
    }

    protected static ConfigException newConfigException(String configName, Object configValue) {
        return new ConfigException(String.format("The configured value %s was invalid for %s", configValue, configName));
    }

    protected abstract IOException invalidProtocolHeaderException(String var1);

    protected void validateAddresses(InetAddress destinationAddress) throws IOException {
        if (this.sourceAddress == null) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source address was not configured");
        }
        if (destinationAddress == null) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy destination address was null");
        }
        if (!destinationAddress.getClass().equals(this.sourceAddress.getClass())) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source address type (" + this.sourceAddress.getClass().getName() + ") and the destination address type (" + destinationAddress.getClass().getName() + ") did not match");
        }
    }

    protected void validatePorts(int destinationPort) throws IOException {
        if (this.sourcePort == -1) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source port was not configured");
        }
        if (AbstractProxyProtocolEngine.isPortInvalid(this.sourcePort)) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source port (" + this.sourcePort + ") was invalid");
        }
        if (AbstractProxyProtocolEngine.isPortInvalid(destinationPort)) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy destination port (" + destinationPort + ") was invalid");
        }
    }

    protected static boolean isPortInvalid(Integer port) {
        return port == null || port < 0 || port > 65535;
    }
}

