/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.SampledStat;

public class ExponentialWeightedAvg
extends Avg {
    private final double alpha;

    public ExponentialWeightedAvg(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
        List filteredSamples = samples.stream().filter(sample -> sample.eventCount > 0L).collect(Collectors.toList());
        if (filteredSamples.isEmpty()) {
            return Double.NaN;
        }
        int sampleCount = filteredSamples.size() - 1;
        if (sampleCount == 0) {
            return Double.NaN;
        }
        int startIdx = 0;
        double lastRecordedTimeMs = 0.0;
        for (int idx = 0; idx < filteredSamples.size(); ++idx) {
            SampledStat.Sample s = (SampledStat.Sample)filteredSamples.get(idx);
            if ((double)s.startTimeMs < lastRecordedTimeMs) {
                startIdx = idx;
                break;
            }
            lastRecordedTimeMs = s.startTimeMs;
        }
        double[] emaArray = new double[sampleCount];
        emaArray[0] = ((SampledStat.Sample)filteredSamples.get((int)startIdx)).value / (double)((SampledStat.Sample)filteredSamples.get((int)startIdx)).eventCount;
        for (int i = 1; i < sampleCount; ++i) {
            SampledStat.Sample curSample = (SampledStat.Sample)filteredSamples.get((startIdx + i) % filteredSamples.size());
            emaArray[i] = curSample.value / (double)curSample.eventCount * this.alpha + emaArray[i - 1] * (1.0 - this.alpha);
        }
        return emaArray[sampleCount - 1];
    }
}

