/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Comparator;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanClusterRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanDetailedClusterBalanceStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanReplicaMovementStats;

public class EvenClusterLoadPlan {
    private final EvenClusterLoadPlanReplicaMovementStats movementStats;
    private final EvenClusterLoadPlanBrokerRelatedStats brokerRelatedStats;
    private final EvenClusterLoadPlanClusterRelatedStats clusterRelatedStats;
    private final EvenClusterLoadPlanDetailedClusterBalanceStats clusterBalancedness;
    private final EvenClusterLoadPlanGoalRelatedStats goalRelatedStats;

    public EvenClusterLoadPlan(EvenClusterLoadPlanReplicaMovementStats movementStats, EvenClusterLoadPlanBrokerRelatedStats brokerRelatedStats, EvenClusterLoadPlanClusterRelatedStats clusterRelatedStats, EvenClusterLoadPlanDetailedClusterBalanceStats clusterBalancedness, EvenClusterLoadPlanGoalRelatedStats goalRelatedStats) {
        this.movementStats = movementStats;
        this.brokerRelatedStats = brokerRelatedStats;
        this.clusterRelatedStats = clusterRelatedStats;
        this.clusterBalancedness = clusterBalancedness;
        this.goalRelatedStats = goalRelatedStats;
    }

    public EvenClusterLoadPlanReplicaMovementStats movementStats() {
        return this.movementStats;
    }

    public EvenClusterLoadPlanBrokerRelatedStats brokerRelatedStats() {
        return this.brokerRelatedStats;
    }

    public EvenClusterLoadPlanClusterRelatedStats clusterRelatedStats() {
        return this.clusterRelatedStats;
    }

    public EvenClusterLoadPlanDetailedClusterBalanceStats clusterBalancedness() {
        return this.clusterBalancedness;
    }

    public EvenClusterLoadPlanGoalRelatedStats goalRelatedStats() {
        return this.goalRelatedStats;
    }

    public String printableForm() {
        String lineSeparator = System.lineSeparator();
        StringBuilder output = new StringBuilder().append(String.format("Optimization has %d inter-broker replica(%.2f MB) moves and %d leadership moves with a cluster model of %d recent windows and %.2f%% of the partitions covered.", this.movementStats.interBrokerMoves(), this.movementStats.interBrokerMovesMB(), this.movementStats.leadershipMoves(), this.clusterRelatedStats.recentWindows(), this.clusterRelatedStats.partitionCoveragePercent())).append(lineSeparator).append(String.format("New brokers: %s.", this.brokerRelatedStats.newBrokers())).append(lineSeparator).append(String.format("Dead or removed brokers: %s.", this.brokerRelatedStats.deadOrRemovedBrokers())).append(lineSeparator).append(String.format("Violated goals before optimization: %s.", this.goalRelatedStats.violatedGoalsBeforeOptimization())).append(lineSeparator).append(String.format("Violated goals after optimization: %s.", this.goalRelatedStats.violatedGoalsAfterOptimization())).append(lineSeparator).append(String.format("Goals which generated movements: %s.", this.goalRelatedStats.movementGeneratingGoals())).append(lineSeparator).append(String.format("Excluded topics: %s.", this.clusterRelatedStats.excludedTopics())).append(lineSeparator).append(String.format("Excluded brokers for leadership: %s.", this.brokerRelatedStats.brokersExcludedForLeadership())).append(lineSeparator).append(String.format("Excluded brokers for replica move: %s.", this.brokerRelatedStats.brokersExcludedForReplicaMove())).append(lineSeparator).append(String.format("Counts: %d brokers %d replicas %d topics.", this.clusterRelatedStats.totalBrokers(), this.clusterRelatedStats.totalReplicas(), this.clusterRelatedStats.totalTopics())).append(lineSeparator).append(String.format("On-demand balancedness score before and after: %.2f -> %.2f.", this.clusterBalancedness.balancednessScorePreRebalance(), this.clusterBalancedness.balancednessScorePostRebalance())).append(lineSeparator);
        if (!this.goalRelatedStats.goalStats().isEmpty()) {
            output.append(lineSeparator);
            output.append(lineSeparator);
            output.append(lineSeparator);
            this.goalRelatedStats.goalStats().forEach(goalStats -> output.append(goalStats.printableForm()));
        }
        if (!this.clusterBalancedness.clusterLoadPreRebalance().isEmpty()) {
            output.append(lineSeparator);
            output.append(lineSeparator);
            output.append("Cluster load now:");
            output.append(lineSeparator);
            this.clusterBalancedness.clusterLoadPreRebalance().stream().sorted(Comparator.comparingInt(EvenClusterLoadPlanBrokerStats::brokerId)).forEach(brokerStats -> output.append(brokerStats.getPrintableForm()));
        }
        if (!this.clusterBalancedness.clusterLoadPostRebalance().isEmpty()) {
            output.append(lineSeparator);
            output.append("Cluster load after rebalancing:");
            output.append(lineSeparator);
            this.clusterBalancedness.clusterLoadPostRebalance().stream().sorted(Comparator.comparingInt(EvenClusterLoadPlanBrokerStats::brokerId)).forEach(brokerStats -> output.append(brokerStats.getPrintableForm()));
        }
        return output.toString();
    }
}

