/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;

public class ClusterLinkTaskError {
    private final ClusterLinkTaskErrorCode errCode;
    private final String errMsg;

    public ClusterLinkTaskError(ClusterLinkTaskErrorCode errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public ClusterLinkTaskErrorCode errorCode() {
        return this.errCode;
    }

    public String errorMessage() {
        return this.errMsg;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errCode, this.errMsg});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkTaskError that = (ClusterLinkTaskError)o;
        return Objects.equals((Object)this.errCode, (Object)that.errCode) && Objects.equals(this.errMsg, that.errMsg);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterTaskError(errCode=").append((Object)this.errCode).append(", errMsg=").append(this.errMsg).append(")");
        return str.toString();
    }

    public static enum ClusterLinkTaskErrorCode {
        UNKNOWN(-1),
        NO_ERROR(0),
        INTERNAL_ERROR(1),
        AUTHENTICATION_ERROR(2),
        BROKER_AUTHENTICATION_ERROR(3),
        MISCONFIGURATION_ERROR(4),
        REMOTE_LINK_NOT_FOUND_ERROR(5),
        LINK_NOT_FOUND_ERROR(6),
        CONSUMER_GROUP_IN_USE_ERROR(7),
        AUTHORIZATION_ERROR(8),
        BROKER_AUTHORIZATION_ERROR(9),
        SECURITY_DISABLED_ERROR(10),
        TOPIC_EXISTS_ERROR(11),
        POLICY_VIOLATION_ERROR(12),
        LINK_COORDINATOR_NOT_ENABLED_ERROR(13),
        ACL_LIMIT_EXCEEDED(14),
        REMOTE_MIRROR_NOT_FOUND_ERROR(15),
        UNKNOWN_TOPIC_OR_PARTITION_ERROR(16),
        INVALID_TOPIC(17),
        SUPPRESSED_ERRORS(18),
        INVALID_REQUEST_ERROR(19);

        private short value;

        private ClusterLinkTaskErrorCode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static ClusterLinkTaskErrorCode fromShort(short x) {
            switch (x) {
                case -1: {
                    return UNKNOWN;
                }
                case 0: {
                    return NO_ERROR;
                }
                case 1: {
                    return INTERNAL_ERROR;
                }
                case 2: {
                    return AUTHENTICATION_ERROR;
                }
                case 3: {
                    return BROKER_AUTHENTICATION_ERROR;
                }
                case 4: {
                    return MISCONFIGURATION_ERROR;
                }
                case 5: {
                    return REMOTE_LINK_NOT_FOUND_ERROR;
                }
                case 6: {
                    return LINK_NOT_FOUND_ERROR;
                }
                case 7: {
                    return CONSUMER_GROUP_IN_USE_ERROR;
                }
                case 8: {
                    return AUTHORIZATION_ERROR;
                }
                case 9: {
                    return BROKER_AUTHORIZATION_ERROR;
                }
                case 10: {
                    return SECURITY_DISABLED_ERROR;
                }
                case 11: {
                    return TOPIC_EXISTS_ERROR;
                }
                case 12: {
                    return POLICY_VIOLATION_ERROR;
                }
                case 13: {
                    return LINK_COORDINATOR_NOT_ENABLED_ERROR;
                }
                case 14: {
                    return ACL_LIMIT_EXCEEDED;
                }
                case 15: {
                    return REMOTE_MIRROR_NOT_FOUND_ERROR;
                }
                case 16: {
                    return UNKNOWN_TOPIC_OR_PARTITION_ERROR;
                }
                case 17: {
                    return INVALID_TOPIC;
                }
                case 18: {
                    return SUPPRESSED_ERRORS;
                }
                case 19: {
                    return INVALID_REQUEST_ERROR;
                }
            }
            return UNKNOWN;
        }
    }
}

