/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.HashMap;
import java.util.Map;

public enum MirrorTopicError {
    UNKNOWN(-2, false),
    NOT_SET(-1, false),
    NO_ERROR(0, false),
    SOURCE_TOPIC_MAY_BE_DELETED(1, false),
    SOURCE_TOPIC_ID_CHANGED(2, false),
    SOURCE_PARTITIONS_DECREASED(3, false),
    NON_MONOTONIC_LOG_APPEND_EPOCH(4, false),
    UNEXPECTED_TRUNCATION(5, false),
    UNSUPPORTED_MESSAGE_FORMAT(6, true),
    NON_MONOTONIC_SOURCE_EPOCH(7, false),
    ILLEGAL_STATE(8, false),
    UNSUPPORTED_MIRROR_STATE(9, false),
    RECORD_TOO_LARGE(10, true),
    TRUNCATION_BELOW_HIGH_WATERMARK(11, true);

    private static final MirrorTopicError DEFAULT_ERROR;
    private static Map<Short, MirrorTopicError> codeToError;
    private final short code;
    private final boolean repairable;

    private MirrorTopicError(int code, boolean repairable) {
        this.code = (short)code;
        this.repairable = repairable;
    }

    public short code() {
        return this.code;
    }

    public boolean repairable() {
        return this.repairable;
    }

    public static MirrorTopicError forCode(short code, boolean failed) {
        MirrorTopicError error = codeToError.get(code);
        error = error != null ? error : UNKNOWN;
        return MirrorTopicError.errorOrDefault(error, failed);
    }

    public static MirrorTopicError errorOrDefault(MirrorTopicError error, boolean failed) {
        if (error == null || error == NOT_SET) {
            return failed ? DEFAULT_ERROR : NO_ERROR;
        }
        return error;
    }

    static {
        DEFAULT_ERROR = SOURCE_TOPIC_MAY_BE_DELETED;
        codeToError = new HashMap<Short, MirrorTopicError>();
        for (MirrorTopicError error : MirrorTopicError.values()) {
            if (codeToError.put(error.code, error) == null) continue;
            throw new ExceptionInInitializerError(String.format("Code %d for error %s has already been used", error.code, error.name()));
        }
    }
}

