/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;

public class OffsetForLeaderEpochResult {
    private final Map<TopicPartition, KafkaFuture<OffsetForLeaderEpochResponseData.EpochEndOffset>> endOffsets;

    public OffsetForLeaderEpochResult(Map<TopicPartition, KafkaFuture<OffsetForLeaderEpochResponseData.EpochEndOffset>> endOffsets) {
        this.endOffsets = endOffsets;
    }

    public Map<TopicPartition, KafkaFuture<OffsetForLeaderEpochResponseData.EpochEndOffset>> endOffsets() {
        return this.endOffsets;
    }

    public KafkaFuture<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>> all() {
        return KafkaFuture.allOf(this.endOffsets.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> epochEndOffsets = new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>(this.endOffsets.size());
            try {
                for (Map.Entry<TopicPartition, KafkaFuture<OffsetForLeaderEpochResponseData.EpochEndOffset>> entry : this.endOffsets.entrySet()) {
                    OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = entry.getValue().get();
                    if (epochEndOffset == null) continue;
                    epochEndOffsets.put(entry.getKey(), epochEndOffset);
                }
                return epochEndOffsets;
            }
            catch (Throwable e) {
                throw new KafkaException("OffsetForLeaderEpochResult#all: internal error", e);
            }
        });
    }
}

