/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class ClientAssertionHttpRequestFormatter
implements HttpRequestFormatter {
    private final ClientAssertion clientAssertion;
    private final String clientId;

    ClientAssertionHttpRequestFormatter(ClientAssertion clientAssertion, String clientId) {
        this.clientAssertion = clientAssertion;
        this.clientId = clientId;
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return null;
    }

    @Override
    public String getRequestBody(String scope) throws IOException {
        StringBuilder requestParameters = new StringBuilder();
        requestParameters.append("client_assertion_type=").append("urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer");
        requestParameters.append("&client_assertion=").append(this.clientAssertion.getJwt());
        requestParameters.append("&grant_type=client_credentials");
        if (this.clientId != null && !this.clientId.isEmpty()) {
            requestParameters.append("&client_id=").append(this.clientId);
        }
        if (scope != null && !scope.trim().isEmpty()) {
            scope = scope.trim();
            String encodedScope = URLEncoder.encode(scope, StandardCharsets.UTF_8.name());
            requestParameters.append("&scope=").append(encodedScope);
        }
        return String.valueOf(requestParameters);
    }

    @Override
    public void close() throws IOException {
        this.clientAssertion.close();
    }
}

