/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeNetworkResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<TenantIpAddr> tenantIpAddrList;
    List<ClientApiKeyIpAddr> clientApiKeyIpAddrList;
    List<Property> properties;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("tenant_ip_addr_list", new CompactArrayOf(TenantIpAddr.SCHEMA_0), "The list of tenants and their Ip addresses."), new Field("client_api_key_ip_addr_list", new CompactArrayOf(ClientApiKeyIpAddr.SCHEMA_0), "Information about the failed connection requests."), new Field("properties", new CompactArrayOf(Property.SCHEMA_0), "List of network properties in the form of key, value pairs"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeNetworkResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeNetworkResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.tenantIpAddrList = new ArrayList<TenantIpAddr>(0);
        this.clientApiKeyIpAddrList = new ArrayList<ClientApiKeyIpAddr>(0);
        this.properties = new ArrayList<Property>(0);
    }

    @Override
    public short apiKey() {
        return 10036;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field tenantIpAddrList was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TenantIpAddr> newCollection = new ArrayList<TenantIpAddr>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TenantIpAddr(_readable, _version, _context));
        }
        this.tenantIpAddrList = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field clientApiKeyIpAddrList was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((TenantIpAddr)((Object)new ClientApiKeyIpAddr(_readable, _version, _context)));
        }
        this.clientApiKeyIpAddrList = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field properties was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((TenantIpAddr)((Object)new Property(_readable, _version, _context)));
        }
        this.properties = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.tenantIpAddrList.size() + 1);
        _stringBytes = this.tenantIpAddrList.iterator();
        while (_stringBytes.hasNext()) {
            TenantIpAddr tenantIpAddrListElement = (TenantIpAddr)_stringBytes.next();
            tenantIpAddrListElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.clientApiKeyIpAddrList.size() + 1);
        for (ClientApiKeyIpAddr clientApiKeyIpAddrListElement : this.clientApiKeyIpAddrList) {
            clientApiKeyIpAddrListElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.properties.size() + 1);
        for (Property propertiesElement : this.properties) {
            propertiesElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tenantIpAddrList.size() + 1));
        for (TenantIpAddr tenantIpAddrListElement : this.tenantIpAddrList) {
            tenantIpAddrListElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clientApiKeyIpAddrList.size() + 1));
        for (ClientApiKeyIpAddr clientApiKeyIpAddrListElement : this.clientApiKeyIpAddrList) {
            clientApiKeyIpAddrListElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.properties.size() + 1));
        for (Property propertiesElement : this.properties) {
            propertiesElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeNetworkResponseData)) {
            return false;
        }
        DescribeNetworkResponseData other = (DescribeNetworkResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.tenantIpAddrList == null ? other.tenantIpAddrList != null : !this.tenantIpAddrList.equals(other.tenantIpAddrList)) {
            return false;
        }
        if (this.clientApiKeyIpAddrList == null ? other.clientApiKeyIpAddrList != null : !this.clientApiKeyIpAddrList.equals(other.clientApiKeyIpAddrList)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.tenantIpAddrList == null ? 0 : this.tenantIpAddrList.hashCode());
        hashCode = 31 * hashCode + (this.clientApiKeyIpAddrList == null ? 0 : this.clientApiKeyIpAddrList.hashCode());
        hashCode = 31 * hashCode + (this.properties == null ? 0 : this.properties.hashCode());
        return hashCode;
    }

    @Override
    public DescribeNetworkResponseData duplicate() {
        DescribeNetworkResponseData _duplicate = new DescribeNetworkResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<TenantIpAddr> newTenantIpAddrList = new ArrayList<TenantIpAddr>(this.tenantIpAddrList.size());
        for (TenantIpAddr tenantIpAddr : this.tenantIpAddrList) {
            newTenantIpAddrList.add(tenantIpAddr.duplicate());
        }
        _duplicate.tenantIpAddrList = newTenantIpAddrList;
        ArrayList<ClientApiKeyIpAddr> newClientApiKeyIpAddrList = new ArrayList<ClientApiKeyIpAddr>(this.clientApiKeyIpAddrList.size());
        for (ClientApiKeyIpAddr _element : this.clientApiKeyIpAddrList) {
            newClientApiKeyIpAddrList.add(_element.duplicate());
        }
        _duplicate.clientApiKeyIpAddrList = newClientApiKeyIpAddrList;
        ArrayList<Property> arrayList = new ArrayList<Property>(this.properties.size());
        for (Property _element : this.properties) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.properties = arrayList;
        return _duplicate;
    }

    public String toString() {
        return "DescribeNetworkResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", tenantIpAddrList=" + MessageUtil.deepToString(this.tenantIpAddrList.iterator()) + ", clientApiKeyIpAddrList=" + MessageUtil.deepToString(this.clientApiKeyIpAddrList.iterator()) + ", properties=" + MessageUtil.deepToString(this.properties.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<TenantIpAddr> tenantIpAddrList() {
        return this.tenantIpAddrList;
    }

    public List<ClientApiKeyIpAddr> clientApiKeyIpAddrList() {
        return this.clientApiKeyIpAddrList;
    }

    public List<Property> properties() {
        return this.properties;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeNetworkResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeNetworkResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeNetworkResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeNetworkResponseData setTenantIpAddrList(List<TenantIpAddr> v) {
        this.tenantIpAddrList = v;
        return this;
    }

    public DescribeNetworkResponseData setClientApiKeyIpAddrList(List<ClientApiKeyIpAddr> v) {
        this.clientApiKeyIpAddrList = v;
        return this;
    }

    public DescribeNetworkResponseData setProperties(List<Property> v) {
        this.properties = v;
        return this;
    }

    public static class Property
    implements Message {
        String name;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "Client API Key associated with the failed request."), new Field("value", Type.COMPACT_STRING, "Client Ip address corresponding to the failed request."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Property(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Property() {
            this.name = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Property");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Property");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Property)) {
                return false;
            }
            Property other = (Property)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        @Override
        public Property duplicate() {
            Property _duplicate = new Property();
            _duplicate.name = this.name;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "Property(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Property setName(String v) {
            this.name = v;
            return this;
        }

        public Property setValue(String v) {
            this.value = v;
            return this;
        }
    }

    public static class ClientApiKeyIpAddr
    implements Message {
        String clientApiKey;
        String ipAddress;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("client_api_key", Type.COMPACT_STRING, "Client API Key associated with the failed request."), new Field("ip_address", Type.COMPACT_STRING, "Client Ip address corresponding to the failed request."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ClientApiKeyIpAddr(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ClientApiKeyIpAddr() {
            this.clientApiKey = "";
            this.ipAddress = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClientApiKeyIpAddr");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientApiKey was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientApiKey had invalid length " + length);
            }
            this.clientApiKey = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field ipAddress was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field ipAddress had invalid length " + length);
            }
            this.ipAddress = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.clientApiKey);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.ipAddress);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ClientApiKeyIpAddr");
            }
            byte[] _stringBytes = this.clientApiKey.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientApiKey' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientApiKey, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.ipAddress.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'ipAddress' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.ipAddress, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClientApiKeyIpAddr)) {
                return false;
            }
            ClientApiKeyIpAddr other = (ClientApiKeyIpAddr)obj;
            if (this.clientApiKey == null ? other.clientApiKey != null : !this.clientApiKey.equals(other.clientApiKey)) {
                return false;
            }
            if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.clientApiKey == null ? 0 : this.clientApiKey.hashCode());
            hashCode = 31 * hashCode + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
            return hashCode;
        }

        @Override
        public ClientApiKeyIpAddr duplicate() {
            ClientApiKeyIpAddr _duplicate = new ClientApiKeyIpAddr();
            _duplicate.clientApiKey = this.clientApiKey;
            _duplicate.ipAddress = this.ipAddress;
            return _duplicate;
        }

        public String toString() {
            return "ClientApiKeyIpAddr(clientApiKey=" + (this.clientApiKey == null ? "null" : "'" + this.clientApiKey.toString() + "'") + ", ipAddress=" + (this.ipAddress == null ? "null" : "'" + this.ipAddress.toString() + "'") + ")";
        }

        public String clientApiKey() {
            return this.clientApiKey;
        }

        public String ipAddress() {
            return this.ipAddress;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ClientApiKeyIpAddr setClientApiKey(String v) {
            this.clientApiKey = v;
            return this;
        }

        public ClientApiKeyIpAddr setIpAddress(String v) {
            this.ipAddress = v;
            return this;
        }
    }

    public static class TenantIpAddr
    implements Message {
        String tenantId;
        String ipAddress;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("tenant_id", Type.COMPACT_STRING, "The id of the tenant."), new Field("ip_address", Type.COMPACT_STRING, "Client's ip addresses belongs to the tenant"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TenantIpAddr(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TenantIpAddr() {
            this.tenantId = "";
            this.ipAddress = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TenantIpAddr");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field tenantId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field tenantId had invalid length " + length);
            }
            this.tenantId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field ipAddress was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field ipAddress had invalid length " + length);
            }
            this.ipAddress = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.tenantId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.ipAddress);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TenantIpAddr");
            }
            byte[] _stringBytes = this.tenantId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.tenantId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.ipAddress.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'ipAddress' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.ipAddress, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TenantIpAddr)) {
                return false;
            }
            TenantIpAddr other = (TenantIpAddr)obj;
            if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
                return false;
            }
            if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            hashCode = 31 * hashCode + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
            return hashCode;
        }

        @Override
        public TenantIpAddr duplicate() {
            TenantIpAddr _duplicate = new TenantIpAddr();
            _duplicate.tenantId = this.tenantId;
            _duplicate.ipAddress = this.ipAddress;
            return _duplicate;
        }

        public String toString() {
            return "TenantIpAddr(tenantId=" + (this.tenantId == null ? "null" : "'" + this.tenantId.toString() + "'") + ", ipAddress=" + (this.ipAddress == null ? "null" : "'" + this.ipAddress.toString() + "'") + ")";
        }

        public String tenantId() {
            return this.tenantId;
        }

        public String ipAddress() {
            return this.ipAddress;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TenantIpAddr setTenantId(String v) {
            this.tenantId = v;
            return this;
        }

        public TenantIpAddr setIpAddress(String v) {
            this.ipAddress = v;
            return this;
        }
    }
}

