/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum AlterMirrorOp {
    PROMOTE(0, false, false, false),
    FAILOVER(1, false, false, false),
    PAUSE(2, false, false, false),
    RESUME(3, false, false, false),
    PAUSE_LINK(4, true, false, false),
    RESUME_LINK(5, true, false, false),
    CLEAR(6, true, false, false),
    STOP(7, true, false, false),
    CLEAR_OFFSETS(8, true, false, false),
    START_PENDING_MIRROR(9, true, true, false),
    PAUSE_PENDING_MIRROR(10, true, true, false),
    CONVERT_TO_START_PENDING_MIRROR(11, false, true, true),
    REVERSE_AND_START_REMOTE_MIRROR(12, false, true, true),
    REVERSE_AND_PAUSE_REMOTE_MIRROR(13, false, true, true),
    CONVERT_TO_PAUSE_PENDING_MIRROR(14, false, true, true),
    FAIL_MIRROR(15, true, false, false),
    REPAIR(16, false, false, true),
    COMPLETE_REPAIR(17, true, false, false),
    ROLLBACK(18, false, true, true);

    private static final Map<Byte, AlterMirrorOp> OPERATIONS;
    private final byte id;
    private final boolean isInternal;
    private final boolean needsAlterMirrorsOnKRaftController;
    private final boolean isMakeMirrorOp;

    private AlterMirrorOp(byte id, boolean isInternal, boolean needsAlterMirrorsOnKRaftController, boolean isMakeMirrorOp) {
        this.id = id;
        this.isInternal = isInternal;
        this.needsAlterMirrorsOnKRaftController = needsAlterMirrorsOnKRaftController;
        this.isMakeMirrorOp = isMakeMirrorOp;
    }

    public byte id() {
        return this.id;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    boolean needsAlterMirrorsOnKRaftController() {
        return this.needsAlterMirrorsOnKRaftController;
    }

    boolean isMakeMirrorOp() {
        return this.isMakeMirrorOp;
    }

    public static AlterMirrorOp forId(byte id) {
        return OPERATIONS.get(id);
    }

    static {
        OPERATIONS = Collections.unmodifiableMap(Arrays.stream(AlterMirrorOp.values()).collect(Collectors.toMap(AlterMirrorOp::id, Function.identity())));
    }
}

