/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.audit;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditLogProviderFactory {
    protected static final Logger log = LoggerFactory.getLogger(AuditLogProviderFactory.class);

    public static AuditLogProvider create(Map<String, ?> configs, String clusterId) {
        ServiceLoader<AuditLogProvider> providers = ServiceLoader.load(AuditLogProvider.class);
        for (AuditLogProvider provider : providers) {
            if (!provider.providerConfigured(configs)) continue;
            provider.configure(configs);
            if (provider instanceof ClusterResourceListener) {
                ((ClusterResourceListener)((Object)provider)).onUpdate(new ClusterResource(clusterId));
            }
            return provider;
        }
        log.warn("Could not find suitable AuditLogProvider implementation.");
        return NoOpAuditLogProvider.INSTANCE;
    }
}

