/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeMirrorsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public DescribeMirrorsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeMirrorsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 10009;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicData(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.topics == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                TopicData topicsElement = (TopicData)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.topics == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (TopicData topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeMirrorsResponseData)) {
            return false;
        }
        DescribeMirrorsResponseData other = (DescribeMirrorsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public DescribeMirrorsResponseData duplicate() {
        DescribeMirrorsResponseData _duplicate = new DescribeMirrorsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
            for (TopicData _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        return _duplicate;
    }

    public String toString() {
        return "DescribeMirrorsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeMirrorsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeMirrorsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeMirrorsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeMirrorsResponseData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_0), "The mirror topic descriptions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_2), "The mirror topic descriptions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_3), "The mirror topic descriptions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_4), "The mirror topic descriptions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_6 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_6), "The mirror topic descriptions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }

    public static class MirrorStateTransitionErrorData
    implements Message {
        short mirrorStateTransitionErrorCode;
        String mirrorStateTransitionErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_6 = new Schema(new Field("mirror_state_transition_error_code", Type.INT16, "The error code, or `0` if the mirror state transition is not in an error state."), new Field("mirror_state_transition_error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror state transition is not in an error state."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, SCHEMA_6};
        public static final short LOWEST_SUPPORTED_VERSION = 6;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public MirrorStateTransitionErrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorStateTransitionErrorData() {
            this.mirrorStateTransitionErrorCode = 0;
            this.mirrorStateTransitionErrorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorStateTransitionErrorData");
            }
            this.mirrorStateTransitionErrorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.mirrorStateTransitionErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field mirrorStateTransitionErrorMessage had invalid length " + length);
                }
                this.mirrorStateTransitionErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorStateTransitionErrorData");
            }
            int _numTaggedFields = 0;
            _writable.writeShort(this.mirrorStateTransitionErrorCode);
            if (this.mirrorStateTransitionErrorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.mirrorStateTransitionErrorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorStateTransitionErrorData");
            }
            _size.addBytes(2);
            if (this.mirrorStateTransitionErrorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.mirrorStateTransitionErrorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'mirrorStateTransitionErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.mirrorStateTransitionErrorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorStateTransitionErrorData)) {
                return false;
            }
            MirrorStateTransitionErrorData other = (MirrorStateTransitionErrorData)obj;
            if (this.mirrorStateTransitionErrorCode != other.mirrorStateTransitionErrorCode) {
                return false;
            }
            if (this.mirrorStateTransitionErrorMessage == null ? other.mirrorStateTransitionErrorMessage != null : !this.mirrorStateTransitionErrorMessage.equals(other.mirrorStateTransitionErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.mirrorStateTransitionErrorCode;
            hashCode = 31 * hashCode + (this.mirrorStateTransitionErrorMessage == null ? 0 : this.mirrorStateTransitionErrorMessage.hashCode());
            return hashCode;
        }

        @Override
        public MirrorStateTransitionErrorData duplicate() {
            MirrorStateTransitionErrorData _duplicate = new MirrorStateTransitionErrorData();
            _duplicate.mirrorStateTransitionErrorCode = this.mirrorStateTransitionErrorCode;
            _duplicate.mirrorStateTransitionErrorMessage = this.mirrorStateTransitionErrorMessage == null ? null : this.mirrorStateTransitionErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "MirrorStateTransitionErrorData(mirrorStateTransitionErrorCode=" + this.mirrorStateTransitionErrorCode + ", mirrorStateTransitionErrorMessage=" + (this.mirrorStateTransitionErrorMessage == null ? "null" : "'" + this.mirrorStateTransitionErrorMessage.toString() + "'") + ")";
        }

        public short mirrorStateTransitionErrorCode() {
            return this.mirrorStateTransitionErrorCode;
        }

        public String mirrorStateTransitionErrorMessage() {
            return this.mirrorStateTransitionErrorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorStateTransitionErrorData setMirrorStateTransitionErrorCode(short v) {
            this.mirrorStateTransitionErrorCode = v;
            return this;
        }

        public MirrorStateTransitionErrorData setMirrorStateTransitionErrorMessage(String v) {
            this.mirrorStateTransitionErrorMessage = v;
            return this;
        }
    }

    public static class TopicData
    implements Message {
        short errorCode;
        String errorMessage;
        String topic;
        String linkName;
        String linkId;
        String mirrorTopic;
        int numPartitions;
        String state;
        long stateTimeMs;
        List<Long> stoppedLogEndOffsets;
        Uuid sourceTopicId;
        short mirrorTopicError;
        List<MirrorStateTransitionErrorData> mirrorStateTransitionErrors;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.topic = "";
            this.linkName = "";
            this.linkId = "";
            this.mirrorTopic = "";
            this.numPartitions = 0;
            this.state = "";
            this.stateTimeMs = 0L;
            this.stoppedLogEndOffsets = new ArrayList<Long>(0);
            this.sourceTopicId = Uuid.ZERO_UUID;
            this.mirrorTopicError = (short)-1;
            this.mirrorStateTransitionErrors = new ArrayList<MirrorStateTransitionErrorData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<Long> newCollection;
            int arrayLength;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkId had invalid length " + length);
            }
            this.linkId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field mirrorTopic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field mirrorTopic had invalid length " + length);
            }
            this.mirrorTopic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.numPartitions = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field state was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field state had invalid length " + length);
            }
            this.state = _readable.readString(length);
            this.stateTimeMs = _readable.readLong();
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.stoppedLogEndOffsets = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList<Long>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.stoppedLogEndOffsets = newCollection;
                }
            } else {
                this.stoppedLogEndOffsets = new ArrayList<Long>(0);
            }
            this.sourceTopicId = _version >= 3 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.mirrorTopicError = _version >= 4 ? _readable.readShort() : (short)-1;
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.mirrorStateTransitionErrors = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((Long)((Object)new MirrorStateTransitionErrorData(_readable, _version, _context)));
                    }
                    this.mirrorStateTransitionErrors = newCollection;
                }
            } else {
                this.mirrorStateTransitionErrors = new ArrayList<MirrorStateTransitionErrorData>(0);
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.linkId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.mirrorTopic);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.numPartitions);
            _stringBytes = _cache.getSerializedValue(this.state);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeLong(this.stateTimeMs);
            if (_version >= 2) {
                if (this.stoppedLogEndOffsets == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
                    _stringBytes = this.stoppedLogEndOffsets.iterator();
                    while (_stringBytes.hasNext()) {
                        Long stoppedLogEndOffsetsElement = (Long)_stringBytes.next();
                        _writable.writeLong(stoppedLogEndOffsetsElement);
                    }
                }
            } else if (this.stoppedLogEndOffsets == null || !this.stoppedLogEndOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default stoppedLogEndOffsets at version " + _version);
            }
            if (_version >= 3) {
                _writable.writeUuid(this.sourceTopicId);
            } else if (!this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                throw new UnsupportedVersionException("Attempted to write a non-default sourceTopicId at version " + _version);
            }
            if (_version >= 4) {
                _writable.writeShort(this.mirrorTopicError);
            } else if (this.mirrorTopicError != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorTopicError at version " + _version);
            }
            if (_version >= 6) {
                if (this.mirrorStateTransitionErrors == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.mirrorStateTransitionErrors.size() + 1);
                    for (MirrorStateTransitionErrorData mirrorStateTransitionErrorsElement : this.mirrorStateTransitionErrors) {
                        mirrorStateTransitionErrorsElement.write(_writable, _cache, _version, _context);
                    }
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = _context.write(EntityType.LINK_NAME, this.linkName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.linkId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = _context.write(EntityType.TOPIC_NAME, this.mirrorTopic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'mirrorTopic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.mirrorTopic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _stringBytes = this.state.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'state' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.state, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(8);
            if (_version >= 2) {
                if (this.stoppedLogEndOffsets == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stoppedLogEndOffsets.size() + 1));
                    _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
                }
            }
            if (_version >= 3) {
                _size.addBytes(16);
            }
            if (_version >= 4) {
                _size.addBytes(2);
            }
            if (_version >= 6) {
                if (this.mirrorStateTransitionErrors == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorStateTransitionErrors.size() + 1));
                    for (MirrorStateTransitionErrorData mirrorStateTransitionErrorsElement : this.mirrorStateTransitionErrors) {
                        mirrorStateTransitionErrorsElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (this.linkId == null ? other.linkId != null : !this.linkId.equals(other.linkId)) {
                return false;
            }
            if (this.mirrorTopic == null ? other.mirrorTopic != null : !this.mirrorTopic.equals(other.mirrorTopic)) {
                return false;
            }
            if (this.numPartitions != other.numPartitions) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            if (this.stateTimeMs != other.stateTimeMs) {
                return false;
            }
            if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
                return false;
            }
            if (!this.sourceTopicId.equals(other.sourceTopicId)) {
                return false;
            }
            if (this.mirrorTopicError != other.mirrorTopicError) {
                return false;
            }
            if (this.mirrorStateTransitionErrors == null ? other.mirrorStateTransitionErrors != null : !this.mirrorStateTransitionErrors.equals(other.mirrorStateTransitionErrors)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + (this.linkId == null ? 0 : this.linkId.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopic == null ? 0 : this.mirrorTopic.hashCode());
            hashCode = 31 * hashCode + this.numPartitions;
            hashCode = 31 * hashCode + (this.state == null ? 0 : this.state.hashCode());
            hashCode = 31 * hashCode + ((int)(this.stateTimeMs >> 32) ^ (int)this.stateTimeMs);
            hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
            hashCode = 31 * hashCode + this.sourceTopicId.hashCode();
            hashCode = 31 * hashCode + this.mirrorTopicError;
            hashCode = 31 * hashCode + (this.mirrorStateTransitionErrors == null ? 0 : this.mirrorStateTransitionErrors.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.topic = this.topic;
            _duplicate.linkName = this.linkName;
            _duplicate.linkId = this.linkId;
            _duplicate.mirrorTopic = this.mirrorTopic;
            _duplicate.numPartitions = this.numPartitions;
            _duplicate.state = this.state;
            _duplicate.stateTimeMs = this.stateTimeMs;
            if (this.stoppedLogEndOffsets == null) {
                _duplicate.stoppedLogEndOffsets = null;
            } else {
                ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
                for (Long l : this.stoppedLogEndOffsets) {
                    newStoppedLogEndOffsets.add(l);
                }
                _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
            }
            _duplicate.sourceTopicId = this.sourceTopicId;
            _duplicate.mirrorTopicError = this.mirrorTopicError;
            if (this.mirrorStateTransitionErrors == null) {
                _duplicate.mirrorStateTransitionErrors = null;
            } else {
                ArrayList<MirrorStateTransitionErrorData> newMirrorStateTransitionErrors = new ArrayList<MirrorStateTransitionErrorData>(this.mirrorStateTransitionErrors.size());
                for (MirrorStateTransitionErrorData mirrorStateTransitionErrorData : this.mirrorStateTransitionErrors) {
                    newMirrorStateTransitionErrors.add(mirrorStateTransitionErrorData.duplicate());
                }
                _duplicate.mirrorStateTransitionErrors = newMirrorStateTransitionErrors;
            }
            return _duplicate;
        }

        public String toString() {
            return "TopicData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", linkName=" + (this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", linkId=" + (this.linkId == null ? "null" : "'" + this.linkId.toString() + "'") + ", mirrorTopic=" + (this.mirrorTopic == null ? "null" : "'" + this.mirrorTopic.toString() + "'") + ", numPartitions=" + this.numPartitions + ", state=" + (this.state == null ? "null" : "'" + this.state.toString() + "'") + ", stateTimeMs=" + this.stateTimeMs + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ", sourceTopicId=" + this.sourceTopicId.toString() + ", mirrorTopicError=" + this.mirrorTopicError + ", mirrorStateTransitionErrors=" + (this.mirrorStateTransitionErrors == null ? "null" : MessageUtil.deepToString(this.mirrorStateTransitionErrors.iterator())) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String topic() {
            return this.topic;
        }

        public String linkName() {
            return this.linkName;
        }

        public String linkId() {
            return this.linkId;
        }

        public String mirrorTopic() {
            return this.mirrorTopic;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public String state() {
            return this.state;
        }

        public long stateTimeMs() {
            return this.stateTimeMs;
        }

        public List<Long> stoppedLogEndOffsets() {
            return this.stoppedLogEndOffsets;
        }

        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        public short mirrorTopicError() {
            return this.mirrorTopicError;
        }

        public List<MirrorStateTransitionErrorData> mirrorStateTransitionErrors() {
            return this.mirrorStateTransitionErrors;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TopicData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public TopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicData setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public TopicData setLinkId(String v) {
            this.linkId = v;
            return this;
        }

        public TopicData setMirrorTopic(String v) {
            this.mirrorTopic = v;
            return this;
        }

        public TopicData setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public TopicData setState(String v) {
            this.state = v;
            return this;
        }

        public TopicData setStateTimeMs(long v) {
            this.stateTimeMs = v;
            return this;
        }

        public TopicData setStoppedLogEndOffsets(List<Long> v) {
            this.stoppedLogEndOffsets = v;
            return this;
        }

        public TopicData setSourceTopicId(Uuid v) {
            this.sourceTopicId = v;
            return this;
        }

        public TopicData setMirrorTopicError(short v) {
            this.mirrorTopicError = v;
            return this;
        }

        public TopicData setMirrorStateTransitionErrors(List<MirrorStateTransitionErrorData> v) {
            this.mirrorStateTransitionErrors = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("link_name", Type.COMPACT_STRING, "The name of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("link_id", Type.COMPACT_STRING, "The ID of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("mirror_topic", Type.COMPACT_STRING, "The name of the source topic over the cluster link that's mirrored, otherwise empty if error."), new Field("num_partitions", Type.INT32, "The number of partitions for the mirror topic, otherwise `0` if error."), new Field("state", Type.COMPACT_STRING, "The state of the topic mirroring, otherwise empty if error."), new Field("state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when the mirror transition to the latest topic state, or `-1` if error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("link_name", Type.COMPACT_STRING, "The name of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("link_id", Type.COMPACT_STRING, "The ID of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("mirror_topic", Type.COMPACT_STRING, "The name of the source topic over the cluster link that's mirrored, otherwise empty if error."), new Field("num_partitions", Type.INT32, "The number of partitions for the mirror topic, otherwise `0` if error."), new Field("state", Type.COMPACT_STRING, "The state of the topic mirroring, otherwise empty if error."), new Field("state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when the mirror transition to the latest topic state, or `-1` if error."), new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "The last source fetch log end offsets when the mirror is stopped in the ascending order of partition ids."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_3 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("link_name", Type.COMPACT_STRING, "The name of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("link_id", Type.COMPACT_STRING, "The ID of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("mirror_topic", Type.COMPACT_STRING, "The name of the source topic over the cluster link that's mirrored, otherwise empty if error."), new Field("num_partitions", Type.INT32, "The number of partitions for the mirror topic, otherwise `0` if error."), new Field("state", Type.COMPACT_STRING, "The state of the topic mirroring, otherwise empty if error."), new Field("state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when the mirror transition to the latest topic state, or `-1` if error."), new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "The last source fetch log end offsets when the mirror is stopped in the ascending order of partition ids."), new Field("source_topic_id", Type.UUID, "The source topic id for the mirror topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("link_name", Type.COMPACT_STRING, "The name of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("link_id", Type.COMPACT_STRING, "The ID of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("mirror_topic", Type.COMPACT_STRING, "The name of the source topic over the cluster link that's mirrored, otherwise empty if error."), new Field("num_partitions", Type.INT32, "The number of partitions for the mirror topic, otherwise `0` if error."), new Field("state", Type.COMPACT_STRING, "The state of the topic mirroring, otherwise empty if error."), new Field("state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when the mirror transition to the latest topic state, or `-1` if error."), new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "The last source fetch log end offsets when the mirror is stopped in the ascending order of partition ids."), new Field("source_topic_id", Type.UUID, "The source topic id for the mirror topic."), new Field("mirror_topic_error", Type.INT16, "Mirror failure reason if the mirror is in failed state."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_6 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the mirror description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the mirror description succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), new Field("link_name", Type.COMPACT_STRING, "The name of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("link_id", Type.COMPACT_STRING, "The ID of the cluster link that the mirror topic uses, otherwise empty if error."), new Field("mirror_topic", Type.COMPACT_STRING, "The name of the source topic over the cluster link that's mirrored, otherwise empty if error."), new Field("num_partitions", Type.INT32, "The number of partitions for the mirror topic, otherwise `0` if error."), new Field("state", Type.COMPACT_STRING, "The state of the topic mirroring, otherwise empty if error."), new Field("state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when the mirror transition to the latest topic state, or `-1` if error."), new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "The last source fetch log end offsets when the mirror is stopped in the ascending order of partition ids."), new Field("source_topic_id", Type.UUID, "The source topic id for the mirror topic."), new Field("mirror_topic_error", Type.INT16, "Mirror failure reason if the mirror is in failed state."), new Field("mirror_state_transition_errors", CompactArrayOf.nullable(MirrorStateTransitionErrorData.SCHEMA_6), "The mirror state transition error data."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }
}

