/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeMirrorsResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class DescribeMirrorsResponseDataJsonConverter {
    public static DescribeMirrorsResponseData read(JsonNode _node, short _version) {
        DescribeMirrorsResponseData _object = new DescribeMirrorsResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("DescribeMirrorsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "DescribeMirrorsResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("DescribeMirrorsResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "DescribeMirrorsResponseData");
        JsonNode _errorMessageNode = _node.get("errorMessage");
        if (_errorMessageNode == null) {
            throw new RuntimeException("DescribeMirrorsResponseData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
        }
        if (_errorMessageNode.isNull()) {
            _object.errorMessage = null;
        } else {
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("DescribeMirrorsResponseData expected a string type, but got " + _node.getNodeType());
            }
            _object.errorMessage = _errorMessageNode.asText();
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("DescribeMirrorsResponseData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (_topicsNode.isNull()) {
            _object.topics = null;
        } else {
            if (!_topicsNode.isArray()) {
                throw new RuntimeException("DescribeMirrorsResponseData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<DescribeMirrorsResponseData.TopicData> _collection = new ArrayList<DescribeMirrorsResponseData.TopicData>(_topicsNode.size());
            _object.topics = _collection;
            for (JsonNode _element : _topicsNode) {
                _collection.add(TopicDataJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(DescribeMirrorsResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        if (_object.errorMessage == null) {
            _node.set("errorMessage", (JsonNode)NullNode.instance);
        } else {
            _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
        }
        if (_object.topics == null) {
            _node.set("topics", (JsonNode)NullNode.instance);
        } else {
            ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
            for (DescribeMirrorsResponseData.TopicData _element : _object.topics) {
                _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("topics", (JsonNode)_topicsArray);
        }
        return _node;
    }

    public static JsonNode write(DescribeMirrorsResponseData _object, short _version) {
        return DescribeMirrorsResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static DescribeMirrorsResponseData.TopicData read(JsonNode _node, short _version) {
            DescribeMirrorsResponseData.TopicData _object = new DescribeMirrorsResponseData.TopicData();
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "TopicData");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            JsonNode _linkNameNode = _node.get("linkName");
            if (_linkNameNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'linkName', which is mandatory in version " + _version);
            }
            if (!_linkNameNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.linkName = _linkNameNode.asText();
            JsonNode _linkIdNode = _node.get("linkId");
            if (_linkIdNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'linkId', which is mandatory in version " + _version);
            }
            if (!_linkIdNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.linkId = _linkIdNode.asText();
            JsonNode _mirrorTopicNode = _node.get("mirrorTopic");
            if (_mirrorTopicNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'mirrorTopic', which is mandatory in version " + _version);
            }
            if (!_mirrorTopicNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.mirrorTopic = _mirrorTopicNode.asText();
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'numPartitions', which is mandatory in version " + _version);
            }
            _object.numPartitions = MessageUtil.jsonNodeToInt(_numPartitionsNode, "TopicData");
            JsonNode _stateNode = _node.get("state");
            if (_stateNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'state', which is mandatory in version " + _version);
            }
            if (!_stateNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.state = _stateNode.asText();
            JsonNode _stateTimeMsNode = _node.get("stateTimeMs");
            if (_stateTimeMsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'stateTimeMs', which is mandatory in version " + _version);
            }
            _object.stateTimeMs = MessageUtil.jsonNodeToLong(_stateTimeMsNode, "TopicData");
            JsonNode _stoppedLogEndOffsetsNode = _node.get("stoppedLogEndOffsets");
            if (_stoppedLogEndOffsetsNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("TopicData: unable to locate field 'stoppedLogEndOffsets', which is mandatory in version " + _version);
                }
                _object.stoppedLogEndOffsets = new ArrayList<Long>(0);
            } else if (_stoppedLogEndOffsetsNode.isNull()) {
                _object.stoppedLogEndOffsets = null;
            } else {
                if (!_stoppedLogEndOffsetsNode.isArray()) {
                    throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Long> _collection = new ArrayList<Long>(_stoppedLogEndOffsetsNode.size());
                _object.stoppedLogEndOffsets = _collection;
                for (JsonNode _element : _stoppedLogEndOffsetsNode) {
                    _collection.add(MessageUtil.jsonNodeToLong(_element, "TopicData element"));
                }
            }
            JsonNode _sourceTopicIdNode = _node.get("sourceTopicId");
            if (_sourceTopicIdNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("TopicData: unable to locate field 'sourceTopicId', which is mandatory in version " + _version);
                }
                _object.sourceTopicId = Uuid.ZERO_UUID;
            } else {
                if (!_sourceTopicIdNode.isTextual()) {
                    throw new RuntimeException("TopicData expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.sourceTopicId = Uuid.fromString(_sourceTopicIdNode.asText());
            }
            JsonNode _mirrorTopicErrorNode = _node.get("mirrorTopicError");
            if (_mirrorTopicErrorNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("TopicData: unable to locate field 'mirrorTopicError', which is mandatory in version " + _version);
                }
                _object.mirrorTopicError = (short)-1;
            } else {
                _object.mirrorTopicError = MessageUtil.jsonNodeToShort(_mirrorTopicErrorNode, "TopicData");
            }
            return _object;
        }

        public static JsonNode write(DescribeMirrorsResponseData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            _node.set("linkName", (JsonNode)new TextNode(_object.linkName));
            _node.set("linkId", (JsonNode)new TextNode(_object.linkId));
            _node.set("mirrorTopic", (JsonNode)new TextNode(_object.mirrorTopic));
            _node.set("numPartitions", (JsonNode)new IntNode(_object.numPartitions));
            _node.set("state", (JsonNode)new TextNode(_object.state));
            _node.set("stateTimeMs", (JsonNode)new LongNode(_object.stateTimeMs));
            if (_version >= 2) {
                if (_object.stoppedLogEndOffsets == null) {
                    _node.set("stoppedLogEndOffsets", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _stoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (Long _element : _object.stoppedLogEndOffsets) {
                        _stoppedLogEndOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
                    }
                    _node.set("stoppedLogEndOffsets", (JsonNode)_stoppedLogEndOffsetsArray);
                }
            } else if (_object.stoppedLogEndOffsets == null || !_object.stoppedLogEndOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default stoppedLogEndOffsets at version " + _version);
            }
            if (_version >= 3) {
                _node.set("sourceTopicId", (JsonNode)new TextNode(_object.sourceTopicId.toString()));
            } else if (!_object.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                throw new UnsupportedVersionException("Attempted to write a non-default sourceTopicId at version " + _version);
            }
            if (_version >= 4) {
                _node.set("mirrorTopicError", (JsonNode)new ShortNode(_object.mirrorTopicError));
            } else if (_object.mirrorTopicError != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorTopicError at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(DescribeMirrorsResponseData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }
}

