/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.clients.consumer.internals.AbstractFetch;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.Fetch;
import org.apache.kafka.clients.consumer.internals.FetchCollector;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class Fetcher<K, V>
extends AbstractFetch<K, V> {
    private final FetchCollector<K, V> fetchCollector;

    public Fetcher(LogContext logContext, ConsumerNetworkClient client, ConsumerMetadata metadata, SubscriptionState subscriptions, FetchConfig<K, V> fetchConfig, FetchMetricsManager metricsManager, Time time) {
        super(logContext, client, metadata, subscriptions, fetchConfig, metricsManager, time);
        this.fetchCollector = new FetchCollector<K, V>(logContext, metadata, subscriptions, fetchConfig, metricsManager, time);
    }

    public void clearBufferedDataForUnassignedPartitions(Collection<TopicPartition> assignedPartitions) {
        this.fetchBuffer.retainAll(new HashSet<TopicPartition>(assignedPartitions));
    }

    public synchronized int sendFetches() {
        Map<Node, FetchSessionHandler.FetchRequestData> fetchRequestMap = this.prepareFetchRequests();
        for (Map.Entry<Node, FetchSessionHandler.FetchRequestData> entry : fetchRequestMap.entrySet()) {
            final Node fetchTarget = entry.getKey();
            final FetchSessionHandler.FetchRequestData data = entry.getValue();
            FetchRequest.Builder request = this.createFetchRequest(fetchTarget, data);
            RequestFutureListener<ClientResponse> listener = new RequestFutureListener<ClientResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(ClientResponse resp) {
                    Fetcher fetcher = Fetcher.this;
                    synchronized (fetcher) {
                        Fetcher.this.handleFetchResponse(fetchTarget, data, resp);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(RuntimeException e) {
                    Fetcher fetcher = Fetcher.this;
                    synchronized (fetcher) {
                        Fetcher.this.handleFetchResponse(fetchTarget, e);
                    }
                }
            };
            RequestFuture<ClientResponse> future = this.client.send(fetchTarget, request);
            future.addListener(listener);
        }
        return fetchRequestMap.size();
    }

    public Fetch<K, V> collectFetch() {
        return this.fetchCollector.collectFetch(this.fetchBuffer);
    }
}

