/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonicLogger {
    private static final Logger LOG = LoggerFactory.getLogger((String)"sonic-logger");
    public static String healthCheckTopicSubstring = "confluent-healthcheck";

    public static void info(SonicEvent event) {
        LOG.info(event.toString());
    }

    public static class SonicControllerSendMetadataEvent
    extends SonicControllerEvent {
        @Override
        public String name() {
            return "SEND_METADATA";
        }
    }

    static abstract class SonicControllerEvent
    extends AbstractSonicEvent {
        SonicControllerEvent() {
        }

        @Override
        public String eventType() {
            return "CONTROLLER";
        }
    }

    public static class SonicUpdateMetadataCompleted
    extends SonicBrokerEvent {
        public SonicUpdateMetadataCompleted(int correlationId, int controllerEpoch) {
            this.tags.add(new SonicTag("correlationId", correlationId));
            this.tags.add(new SonicTag("controllerEpoch", controllerEpoch));
        }

        @Override
        public String name() {
            return "UPDATE_METADATA_COMPLETED";
        }
    }

    public static class SonicUpdateMetadataReceived
    extends SonicBrokerEvent {
        public SonicUpdateMetadataReceived(int correlationId, int controllerEpoch, long numPartitions, Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState> healthcheckTopicPartitions) {
            this.tags.add(new SonicTag("correlationId", correlationId));
            this.tags.add(new SonicTag("controllerEpoch", controllerEpoch));
            this.tags.add(new SonicTag("numPartitions", numPartitions));
            ArrayList<TopicPartitionAndIsr> list = new ArrayList<TopicPartitionAndIsr>();
            for (UpdateMetadataRequestData.UpdateMetadataPartitionState state : healthcheckTopicPartitions) {
                list.add(new TopicPartitionAndIsr(state.topicName(), state.partitionIndex(), state.isr(), state.leader()));
            }
            this.tags.add(new SonicTag("healthcheckTopicPartitions", list));
        }

        @Override
        public String name() {
            return "UPDATE_METADATA_RECEIVED";
        }
    }

    public static class SonicLeaderAndIsrCompleted
    extends SonicBrokerEvent {
        public SonicLeaderAndIsrCompleted(int correlationId, int controllerEpoch) {
            this.tags.add(new SonicTag("correlationId", correlationId));
            this.tags.add(new SonicTag("controllerEpoch", controllerEpoch));
        }

        @Override
        public String name() {
            return "LEADER_AND_ISR_COMPLETED";
        }
    }

    public static class SonicLeaderAndIsrMakeFollowersCompleted
    extends SonicBrokerEvent {
        public SonicLeaderAndIsrMakeFollowersCompleted(int correlationId, int controllerEpoch) {
            this.tags.add(new SonicTag("correlationId", correlationId));
            this.tags.add(new SonicTag("controllerEpoch", controllerEpoch));
        }

        @Override
        public String name() {
            return "LEADER_AND_ISR_MAKE_FOLLOWERS_COMPLETED";
        }
    }

    public static class SonicLeaderAndIsrMakeLeadersCompleted
    extends SonicBrokerEvent {
        public SonicLeaderAndIsrMakeLeadersCompleted(int correlationId, int controllerEpoch) {
            this.tags.add(new SonicTag("correlationId", correlationId));
            this.tags.add(new SonicTag("controllerEpoch", controllerEpoch));
        }

        @Override
        public String name() {
            return "LEADER_AND_ISR_MAKE_LEADERS_COMPLETED";
        }
    }

    public static class SonicLeaderAndIsrReceived
    extends SonicBrokerEvent {
        public SonicLeaderAndIsrReceived(int correlationId, int controllerEpoch, long numPartitions, Iterable<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> healthcheckTopicPartitions) {
            this.tags.add(new SonicTag("correlationId", correlationId));
            this.tags.add(new SonicTag("controllerEpoch", controllerEpoch));
            this.tags.add(new SonicTag("numPartitions", numPartitions));
            ArrayList<TopicPartitionAndIsr> list = new ArrayList<TopicPartitionAndIsr>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState state : healthcheckTopicPartitions) {
                list.add(new TopicPartitionAndIsr(state.topicName(), state.partitionIndex(), state.isr(), state.leader()));
            }
            this.tags.add(new SonicTag("healthcheckTopicPartitions", list));
        }

        @Override
        public String name() {
            return "LEADER_AND_ISR_RECEIVED";
        }
    }

    static abstract class SonicBrokerEvent
    extends AbstractSonicEvent {
        SonicBrokerEvent() {
        }

        @Override
        public String eventType() {
            return "BROKER";
        }
    }

    static abstract class AbstractSonicEvent
    implements SonicEvent {
        List<SonicTag> tags = new ArrayList<SonicTag>();
        long timestamp = System.currentTimeMillis();

        AbstractSonicEvent() {
        }

        public String toString() {
            StringBuilder tagsStrBuilder = new StringBuilder();
            for (SonicTag tag : this.tags()) {
                tagsStrBuilder.append(", ").append(tag.tagName).append(":").append(tag.tagValue);
            }
            return String.format("timestamp:%s, type:%s, name:%s%s", this.timestamp(), this.eventType(), this.name(), tagsStrBuilder);
        }

        @Override
        public List<SonicTag> tags() {
            return this.tags;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }
    }

    static interface SonicEvent {
        public String eventType();

        public String name();

        public List<SonicTag> tags();

        public long timestamp();
    }

    static class TopicPartitionAndIsr {
        String topic;
        int partition;
        List<Integer> isr;
        int leader;

        public TopicPartitionAndIsr(String topic, int partition, List<Integer> isr, int leader) {
            this.topic = topic;
            this.partition = partition;
            this.isr = isr;
            this.leader = leader;
        }

        public String toString() {
            StringBuilder isrStrBuilder = new StringBuilder();
            for (int replica : this.isr) {
                isrStrBuilder.append(replica).append(",");
            }
            if (isrStrBuilder.length() > 1) {
                isrStrBuilder.deleteCharAt(isrStrBuilder.length() - 1);
            }
            return this.topic + "-" + this.partition + " isr:[" + isrStrBuilder.toString() + "] leader:" + this.leader;
        }
    }

    static class SonicTag {
        String tagName;
        Object tagValue;

        public SonicTag(String name, Object value) {
            this.tagName = name;
            this.tagValue = value;
        }
    }
}

