/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.interceptor;

import java.net.InetAddress;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkRequestContext;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;

public class DefaultBrokerInterceptor
implements BrokerInterceptor {
    private final Time time;
    private ClusterLinkSourceMetrics clusterLinkSourceMetrics;

    public DefaultBrokerInterceptor() {
        this(Time.SYSTEM);
    }

    public DefaultBrokerInterceptor(Time time) {
        this.time = time;
    }

    @Override
    public void onAuthenticatedConnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
    }

    @Override
    public void onAuthenticatedDisconnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
    }

    @Override
    public RequestContext newContext(RequestHeader header, String connectionId, long requestId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Metrics metrics, PathAwareSniHostName sniHostName, boolean isPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker) {
        return this.newContext(header, connectionId, requestId, clientAddress, principal, listenerName, securityProtocol, clientInformation, metrics, sniHostName, isPrivilegedListener, principalSerde, authenticationContext, true, produceConsumeAuditLogTracker);
    }

    protected RequestContext newContext(RequestHeader header, String connectionId, long requestId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Metrics metrics, PathAwareSniHostName sniHostName, boolean isPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, boolean allowAllClusterLinkRequestTypes, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker) {
        if (header.clusterLinkId().isPresent() || this.clusterLinkSourceMetrics != null) {
            header.clusterLinkId().ifPresent(linkId -> {
                if (this.clusterLinkSourceMetrics == null) {
                    this.clusterLinkSourceMetrics = new ClusterLinkSourceMetrics(metrics, (Uuid)linkId);
                } else {
                    this.clusterLinkSourceMetrics.ensureLinkId((Uuid)linkId);
                }
            });
            return new ClusterLinkRequestContext(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation, sniHostName, this.time, this.clusterLinkSourceMetrics, isPrivilegedListener, principalSerde, authenticationContext, allowAllClusterLinkRequestTypes);
        }
        return new RequestContext(header, connectionId, requestId, clientAddress, principal, listenerName, securityProtocol, clientInformation, sniHostName, isPrivilegedListener, principalSerde, authenticationContext, produceConsumeAuditLogTracker);
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }

    ClusterLinkSourceMetrics clusterLinkSourceMetrics() {
        return this.clusterLinkSourceMetrics;
    }
}

