/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ConfluentPrincipal
extends KafkaPrincipal {
    public static final String GROUP_TYPE = "Group";
    private final String authenticationId;
    private final Optional<String> networkId;
    private final List<String> authorizationIds;
    private final Set<String> groups;

    public ConfluentPrincipal(String principalType, String name, String authenticationId) {
        this(principalType, name, authenticationId, false);
    }

    public ConfluentPrincipal(String principalType, String name, String authenticationId, boolean delegationTokenAuthenticated) {
        this(principalType, name, authenticationId, Optional.empty(), delegationTokenAuthenticated, Collections.emptySet(), Arrays.asList(name));
    }

    public ConfluentPrincipal(String principalType, String name, String authenticationId, Optional<String> networkId, boolean delegationTokenAuthenticated, Set<String> groups) {
        this(principalType, name, authenticationId, networkId, delegationTokenAuthenticated, groups, Arrays.asList(name));
    }

    public ConfluentPrincipal(String principalType, String name, String authenticationId, Optional<String> networkId, boolean delegationTokenAuthenticated, Set<String> groups, List<String> authorizationIds) {
        super(principalType, name, delegationTokenAuthenticated);
        this.authenticationId = authenticationId == null ? name : authenticationId;
        this.networkId = networkId;
        Set<String> set = this.groups = groups != null ? groups : Collections.emptySet();
        if (authorizationIds == null || authorizationIds.size() == 0) {
            throw new IllegalArgumentException("Authorization id list should contain at least one id");
        }
        this.authorizationIds = authorizationIds;
    }

    public String authenticationId() {
        return this.authenticationId;
    }

    public Optional<String> networkId() {
        return this.networkId;
    }

    public List<String> authorizationIds() {
        return this.authorizationIds;
    }

    public Set<String> getGroups() {
        return this.groups;
    }
}

