/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.nio.channels.SocketChannel;
import java.util.function.Consumer;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ReverseNode;

public class ReverseChannel {
    private final KafkaChannel channel;
    private final ReverseNode reverseNode;
    private final Consumer<KafkaChannel> closeListener;
    private volatile Runnable closeRunnable;

    public ReverseChannel(KafkaChannel channel, ReverseNode reverseNode, Consumer<KafkaChannel> closeListener) {
        this.channel = channel;
        this.reverseNode = reverseNode;
        this.closeListener = closeListener;
    }

    public KafkaChannel channel() {
        return this.channel;
    }

    public ReverseNode reverseNode() {
        return this.reverseNode;
    }

    public Consumer<KafkaChannel> closeListener() {
        return this.closeListener;
    }

    public SocketChannel socketChannel() {
        return this.channel.socketChannel();
    }

    public void closeRunnable(Runnable closeRunnable) {
        this.closeRunnable = closeRunnable;
    }

    public boolean maybeClose() {
        if (this.closeRunnable != null) {
            this.closeRunnable.run();
            return true;
        }
        return false;
    }

    public String toString() {
        return "ReverseChannel(channel=" + this.channel + ", node=" + this.reverseNode + ")";
    }
}

