/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.common.network.ProxyTlvType;

public class ProxyTlv {
    public final ProxyTlvType type;
    public final int length;
    public final byte[] value;

    public ProxyTlv(ProxyTlvType type, byte[] value) {
        this.type = type;
        this.length = value.length;
        this.value = value;
    }

    public static ProxyTlv createForSubtype(ProxyTlvType type, String value) {
        if (!type.subtype().isPresent()) {
            throw new IllegalArgumentException("Type " + type + " does not have a subtype");
        }
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        byte[] buf = new byte[valueBytes.length + 1];
        buf[0] = (byte)(type.subtype().get() & 0xFF);
        System.arraycopy(valueBytes, 0, buf, 1, valueBytes.length);
        return new ProxyTlv(type, buf);
    }

    public ProxyTlvType type() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public byte[] rawValue() {
        return this.value;
    }

    public Object computedValue() {
        return this.type.computeValue(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyTlv proxyTlv = (ProxyTlv)o;
        return this.length == proxyTlv.length && this.type.equals(proxyTlv.type) && Arrays.equals(this.value, proxyTlv.value);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.length);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ProxyTlv.class.getSimpleName() + "[", "]").add("type=" + this.type).add("length=" + this.length).add("value=" + Arrays.toString(this.value)).toString();
    }
}

