/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CreateAclsRequestData
implements ApiMessage {
    List<AclCreation> creations;
    String clusterId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("creations", new ArrayOf(AclCreation.SCHEMA_0), "The ACLs that we want to create."));
    public static final Schema SCHEMA_1 = new Schema(new Field("creations", new ArrayOf(AclCreation.SCHEMA_1), "The ACLs that we want to create."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public CreateAclsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public CreateAclsRequestData() {
        this.creations = new ArrayList<AclCreation>(0);
        this.clusterId = "";
    }

    @Override
    public short apiKey() {
        return 30;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        AclCreation _creationsTransformed;
        AclCreation _creationsRawElement;
        int i;
        ArrayList<AclCreation> newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field creations was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                _creationsRawElement = new AclCreation(_readable, _version, _context);
                _creationsTransformed = (AclCreation)_context.read(EntityType.ACL_RESOURCE, _creationsRawElement);
                newCollection.add(_creationsTransformed);
            }
            this.creations = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field creations was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<AclCreation>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                _creationsRawElement = new AclCreation(_readable, _version, _context);
                _creationsTransformed = (AclCreation)_context.read(EntityType.ACL_RESOURCE, _creationsRawElement);
                newCollection.add(_creationsTransformed);
            }
            this.creations = newCollection;
        }
        this.clusterId = "";
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int length = _readable.readUnsignedVarint() - 1;
                        if (length < 0) {
                            throw new RuntimeException("non-nullable field clusterId was serialized as null");
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field clusterId had invalid length " + length);
                        }
                        this.clusterId = _readable.readString(length);
                        continue block5;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        ArrayList _creationsTransformed;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.creations.size() + 1);
            _creationsTransformed = (ArrayList)_cache.getTransformedValue(this.creations);
            for (AclCreation creationsElement : _creationsTransformed) {
                creationsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.creations.size());
            _creationsTransformed = (ArrayList)_cache.getTransformedValue(this.creations);
            for (AclCreation creationsElement : _creationsTransformed) {
                creationsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 2) {
            if (!this.clusterId.equals("")) {
                ++_numTaggedFields;
            }
        } else if (!this.clusterId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterId at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.clusterId.equals("")) {
                _writable.writeUnsignedVarint(10000);
                byte[] _stringBytes = _cache.getSerializedValue(this.clusterId);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.creations.size() + 1));
        } else {
            _size.addBytes(4);
        }
        ArrayList<AclCreation> _creationsTransformed = new ArrayList<AclCreation>(this.creations.size());
        for (AclCreation creationsElement : this.creations) {
            AclCreation _transformedMessage = (AclCreation)_context.write(EntityType.ACL_RESOURCE, creationsElement);
            _creationsTransformed.add(_transformedMessage);
            _transformedMessage.addSize(_size, _cache, _version, _context);
        }
        _cache.cacheTransformedValue(this.creations, _creationsTransformed);
        if (_version >= 2 && !this.clusterId.equals("")) {
            ++_numTaggedFields;
            _size.addBytes(2);
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateAclsRequestData)) {
            return false;
        }
        CreateAclsRequestData other = (CreateAclsRequestData)obj;
        if (this.creations == null ? other.creations != null : !this.creations.equals(other.creations)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.creations == null ? 0 : this.creations.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        return hashCode;
    }

    @Override
    public CreateAclsRequestData duplicate() {
        CreateAclsRequestData _duplicate = new CreateAclsRequestData();
        ArrayList<AclCreation> newCreations = new ArrayList<AclCreation>(this.creations.size());
        for (AclCreation _element : this.creations) {
            newCreations.add(_element.duplicate());
        }
        _duplicate.creations = newCreations;
        _duplicate.clusterId = this.clusterId;
        return _duplicate;
    }

    public String toString() {
        return "CreateAclsRequestData(creations=" + MessageUtil.deepToString(this.creations.iterator()) + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ")";
    }

    public List<AclCreation> creations() {
        return this.creations;
    }

    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateAclsRequestData setCreations(List<AclCreation> v) {
        this.creations = v;
        return this;
    }

    public CreateAclsRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("creations", new CompactArrayOf(AclCreation.SCHEMA_2), "The ACLs that we want to create."), Field.TaggedFieldsSection.of(10000, new Field("cluster_id", Type.COMPACT_STRING, "Optional cluster-id for centralized ACLs.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class AclCreation
    implements Message {
        byte resourceType;
        String resourceName;
        byte resourcePatternType;
        String principal;
        String host;
        byte operation;
        byte permissionType;
        List<Uuid> clusterLinkIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The type of the resource."), new Field("resource_name", Type.STRING, "The resource name for the ACL."), new Field("principal", Type.STRING, "The principal for the ACL."), new Field("host", Type.STRING, "The host for the ACL."), new Field("operation", Type.INT8, "The operation type for the ACL (read, write, etc.)."), new Field("permission_type", Type.INT8, "The permission type for the ACL (allow, deny, etc.)."));
        public static final Schema SCHEMA_1 = new Schema(new Field("resource_type", Type.INT8, "The type of the resource."), new Field("resource_name", Type.STRING, "The resource name for the ACL."), new Field("resource_pattern_type", Type.INT8, "The pattern type for the ACL."), new Field("principal", Type.STRING, "The principal for the ACL."), new Field("host", Type.STRING, "The host for the ACL."), new Field("operation", Type.INT8, "The operation type for the ACL (read, write, etc.)."), new Field("permission_type", Type.INT8, "The permission type for the ACL (allow, deny, etc.)."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public AclCreation(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AclCreation() {
            this.resourceType = 0;
            this.resourceName = "";
            this.resourcePatternType = (byte)3;
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
            this.clusterLinkIds = new ArrayList<Uuid>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AclCreation");
            }
            this.resourceType = _readable.readByte();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            this.resourcePatternType = _version >= 1 ? _readable.readByte() : (byte)3;
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principal was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principal had invalid length " + length);
            }
            this.principal = _context.read(EntityType.ACL_PRINCIPAL, _readable.readString(length));
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this.clusterLinkIds = new ArrayList<Uuid>(0);
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int arrayLength = _readable.readUnsignedVarint() - 1;
                            if (arrayLength < 0) {
                                throw new RuntimeException("non-nullable field clusterLinkIds was serialized as null");
                            }
                            if (arrayLength > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            ArrayList<Uuid> newCollection = new ArrayList<Uuid>(arrayLength);
                            for (int i = 0; i < arrayLength; ++i) {
                                newCollection.add(_readable.readUuid());
                            }
                            this.clusterLinkIds = newCollection;
                            continue block3;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceType);
            byte[] _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.resourcePatternType);
            } else if (this.resourcePatternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default resourcePatternType at version " + _version);
            }
            _stringBytes = _cache.getSerializedValue(this.principal);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            if (_version >= 2 && !this.clusterLinkIds.isEmpty()) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.clusterLinkIds.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.clusterLinkIds));
                    _writable.writeUnsignedVarint(this.clusterLinkIds.size() + 1);
                    for (Uuid clusterLinkIdsElement : this.clusterLinkIds) {
                        _writable.writeUuid(clusterLinkIdsElement);
                    }
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AclCreation");
            }
            _size.addBytes(1);
            byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if ((_stringBytes = _context.write(EntityType.ACL_PRINCIPAL, this.principal).getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
                throw new RuntimeException("'principal' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principal, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(1);
            _size.addBytes(1);
            if (_version >= 2 && !this.clusterLinkIds.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clusterLinkIds.size() + 1));
                _size.addBytes(this.clusterLinkIds.size() * 16);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.clusterLinkIds, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AclCreation)) {
                return false;
            }
            AclCreation other = (AclCreation)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.resourcePatternType != other.resourcePatternType) {
                return false;
            }
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            if (this.permissionType != other.permissionType) {
                return false;
            }
            if (this.clusterLinkIds == null ? other.clusterLinkIds != null : !this.clusterLinkIds.equals(other.clusterLinkIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.resourcePatternType;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            hashCode = 31 * hashCode + (this.clusterLinkIds == null ? 0 : this.clusterLinkIds.hashCode());
            return hashCode;
        }

        @Override
        public AclCreation duplicate() {
            AclCreation _duplicate = new AclCreation();
            _duplicate.resourceType = this.resourceType;
            _duplicate.resourceName = this.resourceName;
            _duplicate.resourcePatternType = this.resourcePatternType;
            _duplicate.principal = this.principal;
            _duplicate.host = this.host;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            ArrayList<Uuid> newClusterLinkIds = new ArrayList<Uuid>(this.clusterLinkIds.size());
            for (Uuid _element : this.clusterLinkIds) {
                newClusterLinkIds.add(_element);
            }
            _duplicate.clusterLinkIds = newClusterLinkIds;
            return _duplicate;
        }

        public String toString() {
            return "AclCreation(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", resourcePatternType=" + this.resourcePatternType + ", principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ", clusterLinkIds=" + MessageUtil.deepToString(this.clusterLinkIds.iterator()) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte resourcePatternType() {
            return this.resourcePatternType;
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public List<Uuid> clusterLinkIds() {
            return this.clusterLinkIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AclCreation setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public AclCreation setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public AclCreation setResourcePatternType(byte v) {
            this.resourcePatternType = v;
            return this;
        }

        public AclCreation setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public AclCreation setHost(String v) {
            this.host = v;
            return this;
        }

        public AclCreation setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public AclCreation setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        public AclCreation setClusterLinkIds(List<Uuid> v) {
            this.clusterLinkIds = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("resource_type", Type.INT8, "The type of the resource."), new Field("resource_name", Type.COMPACT_STRING, "The resource name for the ACL."), new Field("resource_pattern_type", Type.INT8, "The pattern type for the ACL."), new Field("principal", Type.COMPACT_STRING, "The principal for the ACL."), new Field("host", Type.COMPACT_STRING, "The host for the ACL."), new Field("operation", Type.INT8, "The operation type for the ACL (read, write, etc.)."), new Field("permission_type", Type.INT8, "The permission type for the ACL (allow, deny, etc.)."), Field.TaggedFieldsSection.of(10000, new Field("cluster_link_ids", new CompactArrayOf(Type.UUID), "Cluster link IDs to associate with the link if this ACL was migrated from a source cluster by a cluster link.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

