/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class DegradedBroker {
    private final int brokerId;
    private final HashSet<DegradedBrokerComponent> degradedBrokerComponents;

    public DegradedBroker(int brokerId, Set<DegradedBrokerComponent> degradedBrokerComponents) {
        this.brokerId = brokerId;
        this.degradedBrokerComponents = new HashSet<DegradedBrokerComponent>(degradedBrokerComponents);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Set<DegradedBrokerComponent> degradedBrokerComponents() {
        return this.degradedBrokerComponents;
    }

    public List<String> reasons() {
        return this.degradedBrokerComponents.stream().map(DegradedBrokerComponent::reason).collect(Collectors.toList());
    }

    public DescribeBrokerHealthResponseData.DegradedBroker response(short requestVersion) {
        if (requestVersion < 1) {
            return new DescribeBrokerHealthResponseData.DegradedBroker().setBrokerId(this.brokerId).setDeprecatedReasonsV0(this.degradedBrokerComponents.stream().map(degradedBrokerComponent -> new DescribeBrokerHealthResponseData.Reason().setReason(degradedBrokerComponent.reason())).collect(Collectors.toList()));
        }
        return new DescribeBrokerHealthResponseData.DegradedBroker().setBrokerId(this.brokerId).setDegradedBrokerComponents(this.degradedBrokerComponents.stream().map(degradedBrokerComponent -> new DescribeBrokerHealthResponseData.DegradedBrokerComponent().setReason(degradedBrokerComponent.reason()).setComponentCode(degradedBrokerComponent.brokerComponent().id())).collect(Collectors.toList()));
    }

    public String toString() {
        return "DegradedBroker(brokerId=" + this.brokerId + ", degradedBrokerComponents=" + MessageUtil.deepToString(this.degradedBrokerComponents.iterator()) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DegradedBroker that = (DegradedBroker)o;
        return this.brokerId == that.brokerId() && this.degradedBrokerComponents.equals(that.degradedBrokerComponents());
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.degradedBrokerComponents);
    }
}

