/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum AlterMirrorOp {
    PROMOTE(0, false),
    FAILOVER(1, false),
    PAUSE(2, false),
    RESUME(3, false),
    PAUSE_LINK(4, true),
    RESUME_LINK(5, true),
    CLEAR(6, true),
    STOP(7, true),
    CLEAR_OFFSETS(8, true),
    START_PENDING_MIRROR(9, true),
    PAUSE_PENDING_MIRROR(10, true),
    CONVERT_TO_MIRROR(11, true),
    PROMOTE_LOCAL_AND_START_REMOTE_MIRROR(12, false),
    PROMOTE_LOCAL_AND_PAUSE_REMOTE_MIRROR(13, false);

    private static final Map<Byte, AlterMirrorOp> OPERATIONS;
    private final byte id;
    private final boolean isInternal;

    private AlterMirrorOp(byte id, boolean isInternal) {
        this.id = id;
        this.isInternal = isInternal;
    }

    public byte id() {
        return this.id;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public static AlterMirrorOp forId(byte id) {
        return OPERATIONS.get(id);
    }

    static {
        OPERATIONS = Collections.unmodifiableMap(Arrays.stream(AlterMirrorOp.values()).collect(Collectors.toMap(AlterMirrorOp::id, Function.identity())));
    }
}

