/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.utils.Time;

public class ConnectionExpiryManager {
    private final Map<String, Long> lruConnections;
    private final AtomicLong connectionExpiryTimeoutNanos;
    private final AtomicLong connectionCloseIntervalNanos;
    private final AtomicLong nextCheckTimeNanos;
    private final Time time;

    public ConnectionExpiryManager(Time time, long connectionExpiryMs, long connectionMinCloseIntervalMs) {
        this.connectionExpiryTimeoutNanos = new AtomicLong(TimeUnit.NANOSECONDS.convert(connectionExpiryMs, TimeUnit.MILLISECONDS));
        this.connectionCloseIntervalNanos = new AtomicLong(TimeUnit.NANOSECONDS.convert(connectionMinCloseIntervalMs, TimeUnit.MILLISECONDS));
        this.lruConnections = new LinkedHashMap<String, Long>(16, 0.75f, true);
        this.nextCheckTimeNanos = new AtomicLong(time.nanoseconds() + this.connectionExpiryTimeoutNanos.get());
        this.time = time;
    }

    public ConnectionExpiryManager(Time time, long connectionExpiryMs) {
        this(time, connectionExpiryMs, 0L);
    }

    public void update(String connectionId, long currentTimeNanos) {
        this.lruConnections.put(connectionId, currentTimeNanos);
    }

    public Map.Entry<String, Long> pollExpiredConnections() {
        return this.pollExpiredConnection(this.time.nanoseconds());
    }

    public Map.Entry<String, Long> pollExpiredConnection(long currentTimeNanos) {
        if (currentTimeNanos <= this.nextCheckTimeNanos.get()) {
            return null;
        }
        if (this.lruConnections.isEmpty()) {
            this.nextCheckTimeNanos.set(currentTimeNanos + this.connectionExpiryTimeoutNanos.get());
            return null;
        }
        Map.Entry<String, Long> oldestConnectionEntry = this.lruConnections.entrySet().iterator().next();
        Long connectionLastActiveTime = oldestConnectionEntry.getValue();
        this.nextCheckTimeNanos.set(connectionLastActiveTime + this.connectionExpiryTimeoutNanos.get());
        if (currentTimeNanos > this.nextCheckTimeNanos.get()) {
            this.nextCheckTimeNanos.set(Math.max(this.nextCheckTimeNanos.get(), currentTimeNanos + this.connectionCloseIntervalNanos.get()));
            return oldestConnectionEntry;
        }
        return null;
    }

    public Map.Entry<String, Long> peekOldest() {
        if (this.lruConnections.isEmpty()) {
            return null;
        }
        return this.lruConnections.entrySet().iterator().next();
    }

    public String peekOldestChannelId() {
        Map.Entry<String, Long> oldest = this.peekOldest();
        return oldest == null ? null : oldest.getKey();
    }

    public void remove(String connectionId) {
        this.lruConnections.remove(connectionId);
    }

    public void setConnectionExpiryTime(long newExpiryTimeMs) {
        this.connectionExpiryTimeoutNanos.set(TimeUnit.NANOSECONDS.convert(newExpiryTimeMs, TimeUnit.MILLISECONDS));
        this.nextCheckTimeNanos.set(this.time.nanoseconds());
    }

    public long expiryMs() {
        return TimeUnit.MILLISECONDS.convert(this.connectionExpiryTimeoutNanos.get(), TimeUnit.NANOSECONDS);
    }

    public int size() {
        return this.lruConnections.size();
    }

    public Long connection(String connectionId) {
        return this.lruConnections.get(connectionId);
    }
}

