/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeCellsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<Cell> cells;
    boolean cellsEnabled;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("cells", new CompactArrayOf(Cell.SCHEMA_0), "The list of cells and their detailed information."), new Field("cells_enabled", Type.BOOLEAN, "True if the cells feature is enabled"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeCellsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeCellsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.cells = new ArrayList<Cell>(0);
        this.cellsEnabled = false;
    }

    @Override
    public short apiKey() {
        return 10029;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field cells was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Cell> newCollection = new ArrayList<Cell>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new Cell(_readable, _version, _context));
        }
        this.cells = newCollection;
        this.cellsEnabled = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.cells.size() + 1);
        _stringBytes = this.cells.iterator();
        while (_stringBytes.hasNext()) {
            Cell cellsElement = (Cell)_stringBytes.next();
            cellsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeByte(this.cellsEnabled ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.cells.size() + 1));
        for (Cell cellsElement : this.cells) {
            cellsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeCellsResponseData)) {
            return false;
        }
        DescribeCellsResponseData other = (DescribeCellsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.cells == null ? other.cells != null : !this.cells.equals(other.cells)) {
            return false;
        }
        if (this.cellsEnabled != other.cellsEnabled) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.cells == null ? 0 : this.cells.hashCode());
        hashCode = 31 * hashCode + (this.cellsEnabled ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public DescribeCellsResponseData duplicate() {
        DescribeCellsResponseData _duplicate = new DescribeCellsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<Cell> newCells = new ArrayList<Cell>(this.cells.size());
        for (Cell _element : this.cells) {
            newCells.add(_element.duplicate());
        }
        _duplicate.cells = newCells;
        _duplicate.cellsEnabled = this.cellsEnabled;
        return _duplicate;
    }

    public String toString() {
        return "DescribeCellsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", cells=" + MessageUtil.deepToString(this.cells.iterator()) + ", cellsEnabled=" + (this.cellsEnabled ? "true" : "false") + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<Cell> cells() {
        return this.cells;
    }

    public boolean cellsEnabled() {
        return this.cellsEnabled;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeCellsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeCellsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeCellsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeCellsResponseData setCells(List<Cell> v) {
        this.cells = v;
        return this;
    }

    public DescribeCellsResponseData setCellsEnabled(boolean v) {
        this.cellsEnabled = v;
        return this;
    }

    public static class Cell
    implements Message {
        int cellId;
        byte state;
        List<Integer> brokers;
        boolean openForTenantAssignment;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("cell_id", Type.INT32, "The unique id of the cell."), new Field("state", Type.INT8, "State of the cell"), new Field("brokers", new CompactArrayOf(Type.INT32), "A list of brokers assigned to this cell."), new Field("open_for_tenant_assignment", Type.BOOLEAN, "Whether the cell has enough brokers to be open for tenant assignment. This does not check for cell state. The client should check the cell state to see if it meets their use case."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Cell(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Cell() {
            this.cellId = 0;
            this.state = 0;
            this.brokers = new ArrayList<Integer>(0);
            this.openForTenantAssignment = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Cell");
            }
            this.cellId = _readable.readInt();
            this.state = _readable.readByte();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokers = newCollection;
            this.openForTenantAssignment = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.cellId);
            _writable.writeByte(this.state);
            _writable.writeUnsignedVarint(this.brokers.size() + 1);
            for (Integer brokersElement : this.brokers) {
                _writable.writeInt(brokersElement);
            }
            _writable.writeByte(this.openForTenantAssignment ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Cell");
            }
            _size.addBytes(4);
            _size.addBytes(1);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokers.size() + 1));
            _size.addBytes(this.brokers.size() * 4);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.cellId != other.cellId) {
                return false;
            }
            if (this.state != other.state) {
                return false;
            }
            if (this.brokers == null ? other.brokers != null : !this.brokers.equals(other.brokers)) {
                return false;
            }
            if (this.openForTenantAssignment != other.openForTenantAssignment) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.cellId;
            hashCode = 31 * hashCode + this.state;
            hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
            hashCode = 31 * hashCode + (this.openForTenantAssignment ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public Cell duplicate() {
            Cell _duplicate = new Cell();
            _duplicate.cellId = this.cellId;
            _duplicate.state = this.state;
            ArrayList<Integer> newBrokers = new ArrayList<Integer>(this.brokers.size());
            for (Integer _element : this.brokers) {
                newBrokers.add(_element);
            }
            _duplicate.brokers = newBrokers;
            _duplicate.openForTenantAssignment = this.openForTenantAssignment;
            return _duplicate;
        }

        public String toString() {
            return "Cell(cellId=" + this.cellId + ", state=" + this.state + ", brokers=" + MessageUtil.deepToString(this.brokers.iterator()) + ", openForTenantAssignment=" + (this.openForTenantAssignment ? "true" : "false") + ")";
        }

        public int cellId() {
            return this.cellId;
        }

        public byte state() {
            return this.state;
        }

        public List<Integer> brokers() {
            return this.brokers;
        }

        public boolean openForTenantAssignment() {
            return this.openForTenantAssignment;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Cell setCellId(int v) {
            this.cellId = v;
            return this;
        }

        public Cell setState(byte v) {
            this.state = v;
            return this;
        }

        public Cell setBrokers(List<Integer> v) {
            this.brokers = v;
            return this;
        }

        public Cell setOpenForTenantAssignment(boolean v) {
            this.openForTenantAssignment = v;
            return this;
        }
    }
}

