/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.utils.Time;

public class ConfluentAdminUtils {
    private static final Map<String, MethodHandle> ADMIN_METHODS;

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternalWithCallback", config, requestCallback, proxyProtocolEngineFactory);
    }

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, AdminMetadataManager metadataManager, KafkaClient client, Time time) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternal", config, metadataManager, client, time);
    }

    public static Map<Integer, KafkaFutureImpl<Void>> initiateReverseConnections(ConfluentAdmin admin, InitiateReverseConnectionsRequestData requestData, Integer brokerId) {
        return (Map)ConfluentAdminUtils.invokeAdminMethod("initiateReverseConnections", admin, requestData, brokerId);
    }

    public static AlterConfigsResult incrementalAlterMirrorTopicConfigs(ConfluentAdmin admin, Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        return (AlterConfigsResult)ConfluentAdminUtils.invokeAdminMethod("incrementalAlterMirrorTopicConfigs", admin, configs, options);
    }

    public static DeleteAclsResult deleteAcls(ConfluentAdmin admin, Collection<AclBindingFilter> filters, CreateAclsOptions options, AclState aclState) {
        return (DeleteAclsResult)ConfluentAdminUtils.invokeAdminMethod("deleteAcls", new Object[]{admin, filters, options, aclState});
    }

    public static DescribeAclsResult describeAcls(ConfluentAdmin admin, AclBindingFilter filter, DescribeAclsOptions options, AclState aclState) {
        return (DescribeAclsResult)ConfluentAdminUtils.invokeAdminMethod("describeAcls", new Object[]{admin, filter, options, aclState});
    }

    private static void addAdminMethod(MethodHandles.Lookup lookup, String methodName, Class<?> ... argTypes) {
        try {
            Method method = KafkaAdminClient.class.getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            MethodHandle methodHandle = lookup.unreflect(method);
            ADMIN_METHODS.put(methodName, methodHandle);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new KafkaException("Failed to add method " + methodName, e);
        }
    }

    private static <T> T invokeAdminMethod(String methodName, Object ... args) {
        try {
            MethodHandle methodHandle = ADMIN_METHODS.get(methodName);
            if (methodHandle == null) {
                throw new IllegalArgumentException("Admin method not found: " + methodName);
            }
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw new KafkaException("Admin method invocation failed: " + methodName, t);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ADMIN_METHODS = new HashMap<String, MethodHandle>();
        ConfluentAdminUtils.addAdminMethod(lookup, "createInternal", AdminClientConfig.class, AdminMetadataManager.class, KafkaClient.class, Time.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "createInternalWithCallback", AdminClientConfig.class, RequestCallback.class, ProxyProtocolEngineFactory.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "initiateReverseConnections", InitiateReverseConnectionsRequestData.class, Integer.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "incrementalAlterMirrorTopicConfigs", Map.class, AlterConfigsOptions.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "deleteAcls", Collection.class, DeleteAclsOptions.class, AclState.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "describeAcls", AclBindingFilter.class, DescribeAclsOptions.class, AclState.class);
    }
}

