/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaltImmediately() {
        ArrayList list = new ArrayList();
        Exit.setHaltProcedure((statusCode, message) -> {
            list.add(statusCode);
            list.add(message);
        });
        try {
            int statusCode2 = 0;
            String message2 = "message";
            Exit.halt((int)statusCode2);
            Exit.halt((int)statusCode2, (String)message2);
            Assertions.assertEquals(Arrays.asList(statusCode2, null, statusCode2, message2), list);
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExitImmediately() {
        ArrayList list = new ArrayList();
        Exit.setExitProcedure((statusCode, message) -> {
            list.add(statusCode);
            list.add(message);
        });
        try {
            int statusCode2 = 0;
            String message2 = "message";
            Exit.exit((int)statusCode2);
            Exit.exit((int)statusCode2, (String)message2);
            Assertions.assertEquals(Arrays.asList(statusCode2, null, statusCode2, message2), list);
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddShutdownHookImmediately() {
        ArrayList list = new ArrayList();
        Exit.setShutdownHookAdder((name, runnable) -> {
            list.add(name);
            list.add(runnable);
        });
        try {
            Runnable runnable2 = () -> {};
            String name2 = "name";
            Exit.addShutdownHook((String)name2, (Runnable)runnable2);
            Assertions.assertEquals(Arrays.asList(name2, runnable2), list);
        }
        finally {
            Exit.resetShutdownHookAdder();
        }
    }

    @Test
    public void shouldNotInvokeShutdownHookImmediately() {
        ArrayList list = new ArrayList();
        Runnable runnable = () -> list.add(this);
        Exit.addShutdownHook((String)"message", (Runnable)runnable);
        Assertions.assertEquals((int)0, (int)list.size());
    }
}

