/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteUtilsTest {
    private final byte x00 = 0;
    private final byte x01 = 1;
    private final byte x02 = (byte)2;
    private final byte x0F = (byte)15;
    private final byte x07 = (byte)7;
    private final byte x08 = (byte)8;
    private final byte x3F = (byte)63;
    private final byte x40 = (byte)64;
    private final byte x7E = (byte)126;
    private final byte x7F = (byte)127;
    private final byte xFF = (byte)-1;
    private final byte x80 = (byte)-128;
    private final byte x81 = (byte)-127;
    private final byte xBF = (byte)-65;
    private final byte xC0 = (byte)-64;
    private final byte xFE = (byte)-2;

    @Test
    public void testReadUnsignedIntLEFromArray() {
        byte[] array1 = new byte[]{1, 2, 3, 4, 5};
        Assertions.assertEquals((int)67305985, (int)ByteUtils.readUnsignedIntLE((byte[])array1, (int)0));
        Assertions.assertEquals((int)84148994, (int)ByteUtils.readUnsignedIntLE((byte[])array1, (int)1));
        byte[] array2 = new byte[]{-15, -14, -13, -12, -11, -10};
        Assertions.assertEquals((int)-185339151, (int)ByteUtils.readUnsignedIntLE((byte[])array2, (int)0));
        Assertions.assertEquals((int)-151653133, (int)ByteUtils.readUnsignedIntLE((byte[])array2, (int)2));
    }

    @Test
    public void testReadUnsignedIntLEFromInputStream() throws IOException {
        byte[] array1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArrayInputStream is1 = new ByteArrayInputStream(array1);
        Assertions.assertEquals((int)67305985, (int)ByteUtils.readUnsignedIntLE((InputStream)is1));
        Assertions.assertEquals((int)134678021, (int)ByteUtils.readUnsignedIntLE((InputStream)is1));
        byte[] array2 = new byte[]{-15, -14, -13, -12, -11, -10, -9, -8};
        ByteArrayInputStream is2 = new ByteArrayInputStream(array2);
        Assertions.assertEquals((int)-185339151, (int)ByteUtils.readUnsignedIntLE((InputStream)is2));
        Assertions.assertEquals((int)-117967115, (int)ByteUtils.readUnsignedIntLE((InputStream)is2));
    }

    @Test
    public void testReadUnsignedInt() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        long writeValue = 133444L;
        ByteUtils.writeUnsignedInt((ByteBuffer)buffer, (long)writeValue);
        buffer.flip();
        long readValue = ByteUtils.readUnsignedInt((ByteBuffer)buffer);
        Assertions.assertEquals((long)writeValue, (long)readValue);
    }

    @Test
    public void testWriteUnsignedIntLEToArray() {
        int value1 = 67305985;
        byte[] array1 = new byte[4];
        ByteUtils.writeUnsignedIntLE((byte[])array1, (int)0, (int)value1);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])array1);
        array1 = new byte[8];
        ByteUtils.writeUnsignedIntLE((byte[])array1, (int)2, (int)value1);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 1, 2, 3, 4, 0, 0}, (byte[])array1);
        int value2 = -185339151;
        byte[] array2 = new byte[4];
        ByteUtils.writeUnsignedIntLE((byte[])array2, (int)0, (int)value2);
        Assertions.assertArrayEquals((byte[])new byte[]{-15, -14, -13, -12}, (byte[])array2);
        array2 = new byte[8];
        ByteUtils.writeUnsignedIntLE((byte[])array2, (int)2, (int)value2);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, -15, -14, -13, -12, 0, 0}, (byte[])array2);
    }

    @Test
    public void testWriteUnsignedIntLEToOutputStream() throws IOException {
        int value1 = 67305985;
        ByteArrayOutputStream os1 = new ByteArrayOutputStream();
        ByteUtils.writeUnsignedIntLE((OutputStream)os1, (int)value1);
        ByteUtils.writeUnsignedIntLE((OutputStream)os1, (int)value1);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 1, 2, 3, 4}, (byte[])os1.toByteArray());
        int value2 = -185339151;
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        ByteUtils.writeUnsignedIntLE((OutputStream)os2, (int)value2);
        Assertions.assertArrayEquals((byte[])new byte[]{-15, -14, -13, -12}, (byte[])os2.toByteArray());
    }

    @Test
    public void testUnsignedVarintSerde() throws Exception {
        this.assertUnsignedVarintSerde(0, new byte[]{0});
        this.assertUnsignedVarintSerde(-1, new byte[]{-1, -1, -1, -1, 15});
        this.assertUnsignedVarintSerde(1, new byte[]{1});
        this.assertUnsignedVarintSerde(63, new byte[]{63});
        this.assertUnsignedVarintSerde(-64, new byte[]{-64, -1, -1, -1, 15});
        this.assertUnsignedVarintSerde(64, new byte[]{64});
        this.assertUnsignedVarintSerde(8191, new byte[]{-1, 63});
        this.assertUnsignedVarintSerde(-8192, new byte[]{-128, -64, -1, -1, 15});
        this.assertUnsignedVarintSerde(8192, new byte[]{-128, 64});
        this.assertUnsignedVarintSerde(-8193, new byte[]{-1, -65, -1, -1, 15});
        this.assertUnsignedVarintSerde(1048575, new byte[]{-1, -1, 63});
        this.assertUnsignedVarintSerde(0x100000, new byte[]{-128, -128, 64});
        this.assertUnsignedVarintSerde(Integer.MAX_VALUE, new byte[]{-1, -1, -1, -1, 7});
        this.assertUnsignedVarintSerde(Integer.MIN_VALUE, new byte[]{-128, -128, -128, -128, 8});
    }

    @Test
    public void testVarintSerde() throws Exception {
        this.assertVarintSerde(0, new byte[]{0});
        this.assertVarintSerde(-1, new byte[]{1});
        this.assertVarintSerde(1, new byte[]{2});
        this.assertVarintSerde(63, new byte[]{126});
        this.assertVarintSerde(-64, new byte[]{127});
        this.assertVarintSerde(64, new byte[]{-128, 1});
        this.assertVarintSerde(-65, new byte[]{-127, 1});
        this.assertVarintSerde(8191, new byte[]{-2, 127});
        this.assertVarintSerde(-8192, new byte[]{-1, 127});
        this.assertVarintSerde(8192, new byte[]{-128, -128, 1});
        this.assertVarintSerde(-8193, new byte[]{-127, -128, 1});
        this.assertVarintSerde(1048575, new byte[]{-2, -1, 127});
        this.assertVarintSerde(-1048576, new byte[]{-1, -1, 127});
        this.assertVarintSerde(0x100000, new byte[]{-128, -128, -128, 1});
        this.assertVarintSerde(-1048577, new byte[]{-127, -128, -128, 1});
        this.assertVarintSerde(0x7FFFFFF, new byte[]{-2, -1, -1, 127});
        this.assertVarintSerde(-134217728, new byte[]{-1, -1, -1, 127});
        this.assertVarintSerde(0x8000000, new byte[]{-128, -128, -128, -128, 1});
        this.assertVarintSerde(-134217729, new byte[]{-127, -128, -128, -128, 1});
        this.assertVarintSerde(Integer.MAX_VALUE, new byte[]{-2, -1, -1, -1, 15});
        this.assertVarintSerde(Integer.MIN_VALUE, new byte[]{-1, -1, -1, -1, 15});
    }

    @Test
    public void testVarlongSerde() throws Exception {
        this.assertVarlongSerde(0L, new byte[]{0});
        this.assertVarlongSerde(-1L, new byte[]{1});
        this.assertVarlongSerde(1L, new byte[]{2});
        this.assertVarlongSerde(63L, new byte[]{126});
        this.assertVarlongSerde(-64L, new byte[]{127});
        this.assertVarlongSerde(64L, new byte[]{-128, 1});
        this.assertVarlongSerde(-65L, new byte[]{-127, 1});
        this.assertVarlongSerde(8191L, new byte[]{-2, 127});
        this.assertVarlongSerde(-8192L, new byte[]{-1, 127});
        this.assertVarlongSerde(8192L, new byte[]{-128, -128, 1});
        this.assertVarlongSerde(-8193L, new byte[]{-127, -128, 1});
        this.assertVarlongSerde(1048575L, new byte[]{-2, -1, 127});
        this.assertVarlongSerde(-1048576L, new byte[]{-1, -1, 127});
        this.assertVarlongSerde(0x100000L, new byte[]{-128, -128, -128, 1});
        this.assertVarlongSerde(-1048577L, new byte[]{-127, -128, -128, 1});
        this.assertVarlongSerde(0x7FFFFFFL, new byte[]{-2, -1, -1, 127});
        this.assertVarlongSerde(-134217728L, new byte[]{-1, -1, -1, 127});
        this.assertVarlongSerde(0x8000000L, new byte[]{-128, -128, -128, -128, 1});
        this.assertVarlongSerde(-134217729L, new byte[]{-127, -128, -128, -128, 1});
        this.assertVarlongSerde(Integer.MAX_VALUE, new byte[]{-2, -1, -1, -1, 15});
        this.assertVarlongSerde(Integer.MIN_VALUE, new byte[]{-1, -1, -1, -1, 15});
        this.assertVarlongSerde(0x3FFFFFFFFL, new byte[]{-2, -1, -1, -1, 127});
        this.assertVarlongSerde(-17179869184L, new byte[]{-1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x400000000L, new byte[]{-128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-17179869185L, new byte[]{-127, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0x1FFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-2199023255552L, new byte[]{-1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x20000000000L, new byte[]{-128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-2199023255553L, new byte[]{-127, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0xFFFFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-281474976710656L, new byte[]{-1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x1000000000000L, new byte[]{-128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-281474976710657L, new byte[]{-127, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0x7FFFFFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-36028797018963968L, new byte[]{-1, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x80000000000000L, new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-36028797018963969L, new byte[]{-127, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0x3FFFFFFFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-4611686018427387904L, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x4000000000000000L, new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-4611686018427387905L, new byte[]{-127, -128, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(Long.MAX_VALUE, new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, -1, 1});
        this.assertVarlongSerde(Long.MIN_VALUE, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 1});
    }

    @Test
    public void testInvalidVarint() {
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{-1, -1, -1, -1, -1, 1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.readVarint((ByteBuffer)buf));
    }

    @Test
    public void testInvalidVarlong() {
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.readVarlong((ByteBuffer)buf));
    }

    @Test
    public void testDouble() throws IOException {
        this.assertDoubleSerde(0.0, 0L);
        this.assertDoubleSerde(-0.0, Long.MIN_VALUE);
        this.assertDoubleSerde(1.0, 0x3FF0000000000000L);
        this.assertDoubleSerde(-1.0, -4616189618054758400L);
        this.assertDoubleSerde(1.23E47, 5311304729251330816L);
        this.assertDoubleSerde(-1.23E47, -3912067307603444992L);
        this.assertDoubleSerde(Double.MIN_VALUE, 1L);
        this.assertDoubleSerde(-4.9E-324, -9223372036854775807L);
        this.assertDoubleSerde(Double.MAX_VALUE, 0x7FEFFFFFFFFFFFFFL);
        this.assertDoubleSerde(-1.7976931348623157E308, -4503599627370497L);
        this.assertDoubleSerde(Double.NaN, 9221120237041090560L);
        this.assertDoubleSerde(Double.POSITIVE_INFINITY, 0x7FF0000000000000L);
        this.assertDoubleSerde(Double.NEGATIVE_INFINITY, -4503599627370496L);
    }

    @Test
    public void testSizeOfUnsignedVarint() {
        IntFunction<Integer> simpleImplementation = value -> {
            int bytes = 1;
            while ((long)(value & 0xFFFFFF80) != 0L) {
                ++bytes;
                value >>>= 7;
            }
            return bytes;
        };
        for (int i = 0; i < Integer.MAX_VALUE && i >= 0; i += 13) {
            int actual = ByteUtils.sizeOfUnsignedVarint((int)i);
            int expected = simpleImplementation.apply(i);
            Assertions.assertEquals((int)expected, (int)actual);
        }
    }

    @Test
    public void testSizeOfVarlong() {
        LongFunction<Integer> simpleImplementation = value -> {
            long v = value << 1 ^ value >> 63;
            int bytes = 1;
            while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
                ++bytes;
                v >>>= 7;
            }
            return bytes;
        };
        for (long l = 1L; l < Long.MAX_VALUE && l >= 0L; l <<= 1) {
            int expected = simpleImplementation.apply(l);
            int actual = ByteUtils.sizeOfVarlong((long)l);
            Assertions.assertEquals((int)expected, (int)actual);
        }
        Assertions.assertEquals((Integer)simpleImplementation.apply(0L), (int)ByteUtils.sizeOfVarlong((long)0L));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * values.length);
        for (int i = 0; i < values.length; ++i) {
            buffer.putInt(i * 4, values[i]);
            Assertions.assertEquals((int)values[i], (int)ByteUtils.readIntBE((byte[])buffer.array(), (int)(i * 4)), (String)"Written value should match read value.");
        }
    }

    private void assertUnsignedVarintSerde(int value, byte[] expectedEncoding) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(32);
        ByteUtils.writeUnsignedVarint((int)value, (ByteBuffer)buf);
        buf.flip();
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        Assertions.assertEquals((int)value, (int)ByteUtils.readUnsignedVarint((ByteBuffer)buf.duplicate()));
        buf.rewind();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buf));
        ByteUtils.writeUnsignedVarint((int)value, (DataOutput)out);
        buf.flip();
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        Assertions.assertEquals((int)value, (int)ByteUtils.readUnsignedVarint((DataInput)in));
    }

    private void assertVarintSerde(int value, byte[] expectedEncoding) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(32);
        ByteUtils.writeVarint((int)value, (ByteBuffer)buf);
        buf.flip();
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        Assertions.assertEquals((int)value, (int)ByteUtils.readVarint((ByteBuffer)buf.duplicate()));
        buf.rewind();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buf));
        ByteUtils.writeVarint((int)value, (DataOutput)out);
        buf.flip();
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        Assertions.assertEquals((int)value, (int)ByteUtils.readVarint((DataInput)in));
    }

    private void assertVarlongSerde(long value, byte[] expectedEncoding) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(32);
        ByteUtils.writeVarlong((long)value, (ByteBuffer)buf);
        buf.flip();
        Assertions.assertEquals((long)value, (long)ByteUtils.readVarlong((ByteBuffer)buf.duplicate()));
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        buf.rewind();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buf));
        ByteUtils.writeVarlong((long)value, (DataOutput)out);
        buf.flip();
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        Assertions.assertEquals((long)value, (long)ByteUtils.readVarlong((DataInput)in));
    }

    private void assertDoubleSerde(double value, long expectedLongValue) throws IOException {
        byte[] expectedEncoding = new byte[8];
        for (int i = 0; i < 8; ++i) {
            expectedEncoding[7 - i] = (byte)(expectedLongValue & 0xFFL);
            expectedLongValue >>= 8;
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        ByteUtils.writeDouble((double)value, (ByteBuffer)buf);
        buf.flip();
        Assertions.assertEquals((double)value, (double)ByteUtils.readDouble((ByteBuffer)buf.duplicate()), (double)0.0);
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        buf.rewind();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buf));
        ByteUtils.writeDouble((double)value, (DataOutput)out);
        buf.flip();
        Assertions.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        Assertions.assertEquals((double)value, (double)ByteUtils.readDouble((DataInput)in), (double)0.0);
    }
}

