/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.message.DescribeBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.DescribeBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeBrokerReplicaExclusionsResponseTest {
    @Test
    public void testGetErrorResponse() {
        DescribeBrokerReplicaExclusionsRequest req = new DescribeBrokerReplicaExclusionsRequest(new DescribeBrokerReplicaExclusionsRequestData(), 0);
        DescribeBrokerReplicaExclusionsResponse resp = req.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)resp.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsNoneWhenNoErrors() {
        DescribeBrokerReplicaExclusionsResponseData data = new DescribeBrokerReplicaExclusionsResponseData().setThrottleTimeMs(10).setExcludedBrokers(this.exclusionCollection());
        DescribeBrokerReplicaExclusionsResponse response = new DescribeBrokerReplicaExclusionsResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsOneErrorWhenTopLevelError() {
        DescribeBrokerReplicaExclusionsResponseData data = new DescribeBrokerReplicaExclusionsResponseData().setThrottleTimeMs(10).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setExcludedBrokers(this.exclusionCollection());
        DescribeBrokerReplicaExclusionsResponse response = new DescribeBrokerReplicaExclusionsResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    private DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection exclusionCollection() {
        DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection collection = new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection();
        collection.addAll(Arrays.asList(new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(1).setReason("broker 1"), new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(2).setReason("broker 2"), new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(3).setReason("broker 3")));
        return collection;
    }
}

