/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteTopicsRequestTest {
    @Test
    public void testTopicNormalization() {
        Iterator iterator = ApiKeys.DELETE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            String topic1 = "topic1";
            String topic2 = "topic2";
            List<String> topics = Arrays.asList(topic1, topic2);
            DeleteTopicsRequest requestWithNames = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(topics)).build(version);
            DeleteTopicsRequest requestWithNamesSerialized = DeleteTopicsRequest.parse((ByteBuffer)requestWithNames.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals(topics, (Object)requestWithNames.topicNames());
            Assertions.assertEquals(topics, (Object)requestWithNamesSerialized.topicNames());
            if (version < 6) {
                Assertions.assertEquals(topics, (Object)requestWithNames.data().topicNames());
                Assertions.assertEquals(topics, (Object)requestWithNamesSerialized.data().topicNames());
                continue;
            }
            Assertions.assertEquals(topics, requestWithNames.data().topics().stream().map(DeleteTopicsRequestData.DeleteTopicState::name).collect(Collectors.toList()));
            Assertions.assertEquals(topics, requestWithNamesSerialized.data().topics().stream().map(DeleteTopicsRequestData.DeleteTopicState::name).collect(Collectors.toList()));
        }
    }

    @Test
    public void testNewTopicsField() {
        Iterator iterator = ApiKeys.DELETE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            String topic1 = "topic1";
            String topic2 = "topic2";
            List<String> topics = Arrays.asList(topic1, topic2);
            DeleteTopicsRequest requestWithNames = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setName(topic1), new DeleteTopicsRequestData.DeleteTopicState().setName(topic2)))).build(version);
            if (version >= 6) {
                DeleteTopicsRequest requestWithNamesSerialized = DeleteTopicsRequest.parse((ByteBuffer)requestWithNames.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
                Assertions.assertEquals(topics, (Object)requestWithNames.topicNames());
                Assertions.assertEquals(topics, (Object)requestWithNamesSerialized.topicNames());
                continue;
            }
            Assertions.assertThrows(UnsupportedVersionException.class, () -> requestWithNames.serialize());
        }
    }

    @Test
    public void testTopicIdsField() {
        Iterator iterator = ApiKeys.DELETE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            List<Uuid> topicIds = Arrays.asList(topicId1, topicId2);
            DeleteTopicsRequest requestWithIds = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId(topicId1), new DeleteTopicsRequestData.DeleteTopicState().setTopicId(topicId2)))).build(version);
            if (version >= 6) {
                DeleteTopicsRequest requestWithIdsSerialized = DeleteTopicsRequest.parse((ByteBuffer)requestWithIds.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
                Assertions.assertEquals(topicIds, (Object)requestWithIds.topicIds());
                Assertions.assertEquals(topicIds, (Object)requestWithIdsSerialized.topicIds());
                requestWithIds.data().topics().forEach(topic -> Assertions.assertNull((Object)topic.name()));
                requestWithIdsSerialized.data().topics().forEach(topic -> Assertions.assertNull((Object)topic.name()));
                continue;
            }
            Assertions.assertThrows(UnsupportedVersionException.class, () -> requestWithIds.serialize());
        }
    }

    @Test
    public void testDeleteTopicsRequestNumTopics() {
        Iterator iterator = ApiKeys.DELETE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            DeleteTopicsRequest request = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic1", "topic2")).setTimeoutMs(1000)).build(version);
            DeleteTopicsRequest serializedRequest = DeleteTopicsRequest.parse((ByteBuffer)request.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((int)2, (int)request.numberOfTopics());
            Assertions.assertEquals((int)2, (int)serializedRequest.numberOfTopics());
            if (version < 6) continue;
            DeleteTopicsRequest requestWithIds = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId(Uuid.randomUuid()), new DeleteTopicsRequestData.DeleteTopicState().setTopicId(Uuid.randomUuid())))).build(version);
            DeleteTopicsRequest serializedRequestWithIds = DeleteTopicsRequest.parse((ByteBuffer)requestWithIds.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((int)2, (int)requestWithIds.numberOfTopics());
            Assertions.assertEquals((int)2, (int)serializedRequestWithIds.numberOfTopics());
        }
    }
}

