/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterBrokerHealthResponseTest {
    @Test
    public void testErrorCountsFromTopLevelFailure() {
        AlterBrokerHealthResponseData data = new AlterBrokerHealthResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        AlterBrokerHealthResponse response = new AlterBrokerHealthResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsFromTopLevelFailureAndMultipleBrokers() {
        AlterBrokerHealthResponseData data = new AlterBrokerHealthResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setBrokerHealthStatusResults(Arrays.asList(new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(0).setComponentCode(BrokerComponent.STORAGE.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()), new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(1).setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id())));
        AlterBrokerHealthResponse response = new AlterBrokerHealthResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }
}

