/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverview;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverviewRejectingGoal;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EvenClusterLoadPlanGoalStatsTest {
    @Test
    public void testGetPrintableForm() {
        String goalName = "CpuUsageDistributionGoal";
        double avgCpu = 28.835;
        double avgNetworkInbound = 28240.951;
        double avgProducerInbound = avgNetworkInbound / 3.0;
        double avgNetworkOutbound = 27849.211;
        double avgConsumerOutbound = avgNetworkOutbound / 3.0;
        double avgDisk = 45366.01;
        double avgPotentialNwOut = 87839.004;
        int avgReplicas = 157;
        int avgLeaderReplicas = 52;
        int avgTotalReplicas = 8;
        double maxCpu = 31.273;
        double maxNetworkInbound = 29985.133;
        double maxProducerInbound = maxNetworkInbound / 3.0;
        double maxNetworkOutbound = 29369.832;
        double maxConsumerOutbound = maxNetworkOutbound / 3.0;
        double maxDisk = 48095.633;
        double maxPotentialNwOut = 91267.646;
        int maxReplicas = 172;
        int maxLeaderReplicas = 58;
        int maxTotalReplicas = 50;
        double minCpu = 24.939;
        double minNetworkInbound = 25717.08;
        double minProducerInbound = minNetworkInbound / 3.0;
        double minNetworkOutbound = 25808.67;
        double minConsumerOutbound = minNetworkOutbound / 3.0;
        double minDisk = 43224.656;
        double minPotentialNwOut = 79481.926;
        int minReplicas = 143;
        int minLeaderReplicas = 47;
        int minTotalReplicas = 0;
        double stdCpu = 1.965;
        double stdNetworkInbound = 1286.804;
        double stdProducerInbound = stdNetworkInbound / 3.0;
        double stdNetworkOutbound = 1440.964;
        double stdConsumerOutbound = stdNetworkOutbound / 3.0;
        double stdDisk = 1927.479;
        double stdPotentialNwOut = 4050.075;
        int stdReplicas = 14;
        int stdLeaderReplicas = 5;
        int stdTotalReplicas = 6;
        String overviewStatus = "VIOLATED";
        EvenClusterLoadPlanGoalStatsOverviewRejectingGoal rejectingGoal01 = new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("ReplicaDistributionGoal", 60);
        EvenClusterLoadPlanGoalStatsOverviewRejectingGoal rejectingGoal02 = new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("NetworkInboundUsageDistributionGoal", 37);
        EvenClusterLoadPlanGoalStatsOverviewRejectingGoal rejectingGoal03 = new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("RackAwareGoal", 172);
        EvenClusterLoadPlanGoalStatsOverviewRejectingGoal rejectingGoal04 = new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("LeaderReplicaDistributionGoal", 182);
        EvenClusterLoadPlanGoalStatsOverviewRejectingGoal rejectingGoal05 = new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("NetworkOutboundUsageDistributionGoal", 4);
        int proposalsGenerated = 467;
        int rejectedProposals = 455;
        double rejectedProposalsPercent = 0.97;
        int acceptedProposals = 12;
        double acceptedProposalsPercent = 0.026;
        int moves = 1;
        int swaps = 0;
        EvenClusterLoadPlanGoalStats goalStats = new EvenClusterLoadPlanGoalStats(goalName, new EvenClusterLoadPlanGoalStatsResources(avgCpu, avgNetworkInbound, avgProducerInbound, avgNetworkOutbound, avgConsumerOutbound, avgDisk, avgPotentialNwOut, avgReplicas, avgLeaderReplicas, avgTotalReplicas), new EvenClusterLoadPlanGoalStatsResources(maxCpu, maxNetworkInbound, maxProducerInbound, maxNetworkOutbound, maxConsumerOutbound, maxDisk, maxPotentialNwOut, maxReplicas, maxLeaderReplicas, maxTotalReplicas), new EvenClusterLoadPlanGoalStatsResources(minCpu, minNetworkInbound, minProducerInbound, minNetworkOutbound, minConsumerOutbound, minDisk, minPotentialNwOut, minReplicas, minLeaderReplicas, minTotalReplicas), new EvenClusterLoadPlanGoalStatsResources(stdCpu, stdNetworkInbound, stdProducerInbound, stdNetworkOutbound, stdConsumerOutbound, stdDisk, stdPotentialNwOut, stdReplicas, stdLeaderReplicas, stdTotalReplicas), new EvenClusterLoadPlanGoalStatsOverview(overviewStatus, Arrays.asList(rejectingGoal01, rejectingGoal02, rejectingGoal03, rejectingGoal04, rejectingGoal05), proposalsGenerated, rejectedProposals, rejectedProposalsPercent, acceptedProposals, acceptedProposalsPercent, moves, swaps));
        String printableForm = goalStats.printableForm();
        Assertions.assertTrue((boolean)printableForm.contains("CpuUsageDistributionGoal"));
        Assertions.assertTrue((boolean)printableForm.contains("AVG:"));
        Assertions.assertTrue((boolean)printableForm.contains("MAX:"));
        Assertions.assertTrue((boolean)printableForm.contains("MIN:"));
        Assertions.assertTrue((boolean)printableForm.contains("STD:"));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("AVG: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", avgCpu, avgNetworkInbound, avgProducerInbound, avgNetworkOutbound, avgConsumerOutbound, avgDisk, avgPotentialNwOut, avgReplicas, avgLeaderReplicas, avgTotalReplicas)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("MAX: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", maxCpu, maxNetworkInbound, maxProducerInbound, maxNetworkOutbound, maxConsumerOutbound, maxDisk, maxPotentialNwOut, maxReplicas, maxLeaderReplicas, maxTotalReplicas)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("MIN: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", minCpu, minNetworkInbound, minProducerInbound, minNetworkOutbound, minConsumerOutbound, minDisk, minPotentialNwOut, minReplicas, minLeaderReplicas, minTotalReplicas)));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("STD: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", stdCpu, stdNetworkInbound, stdProducerInbound, stdNetworkOutbound, stdConsumerOutbound, stdDisk, stdPotentialNwOut, stdReplicas, stdLeaderReplicas, stdTotalReplicas)));
        Assertions.assertTrue((boolean)printableForm.contains("VIOLATED"));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("%s: %d", rejectingGoal01.goalName(), rejectingGoal01.proposalsRejected())));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("%s: %d", rejectingGoal02.goalName(), rejectingGoal02.proposalsRejected())));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("%s: %d", rejectingGoal03.goalName(), rejectingGoal03.proposalsRejected())));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("%s: %d", rejectingGoal04.goalName(), rejectingGoal04.proposalsRejected())));
        Assertions.assertTrue((boolean)printableForm.contains(String.format("%s: %d", rejectingGoal05.goalName(), rejectingGoal05.proposalsRejected())));
    }
}

