/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerComponentTest {
    @Test
    public void testIsValid() {
        for (BrokerComponent component : BrokerComponent.values()) {
            IntStream.range(2, 3).forEach(version -> {
                if (component == BrokerComponent.UNKNOWN) {
                    Assertions.assertFalse((boolean)component.isValid((short)version));
                } else {
                    Assertions.assertEquals((Object)(version >= component.minSupportedVersion() ? 1 : 0), (Object)component.isValid((short)version));
                }
            });
        }
    }

    @Test
    public void testSuccessfulDowngrade() {
        short version = 2;
        BrokerComponent component = BrokerComponent.NETWORK;
        Assertions.assertEquals((Object)BrokerComponent.UNSPECIFIED, (Object)component.maybeDowngrade(version));
    }

    @Test
    public void testDoesNotDowngradeWhenNotAllowed() {
        short version = 2;
        BrokerComponent component = BrokerComponent.STORAGE;
        Assertions.assertEquals((Object)BrokerComponent.STORAGE, (Object)component.maybeDowngrade(version));
    }

    @Test
    public void testDoesNotNeedToDowngrade() {
        short version = 3;
        Assertions.assertEquals((Object)BrokerComponent.UNSPECIFIED, (Object)BrokerComponent.UNSPECIFIED.maybeDowngrade(version));
        Assertions.assertEquals((Object)BrokerComponent.STORAGE, (Object)BrokerComponent.STORAGE.maybeDowngrade(version));
    }
}

