/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.DemotedBroker;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeLeadershipPriorityResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeLeadershipPriorityResponse
extends AbstractResponse {
    private final DescribeLeadershipPriorityResponseData data;

    public DescribeLeadershipPriorityResponse(DescribeLeadershipPriorityResponseData data) {
        super(ApiKeys.DESCRIBE_LEADERSHIP_PRIORITY);
        this.data = data;
    }

    public void complete(KafkaFutureImpl<Collection<DemotedBroker>> result) {
        Collection demotedBrokers = this.data.demotedBrokers().stream().map(broker -> new DemotedBroker(broker.brokerId(), broker.reasons().stream().map(DescribeLeadershipPriorityResponseData.Reason::reason).collect(Collectors.toList()))).collect(Collectors.toList());
        result.complete(demotedBrokers);
    }

    @Override
    public DescribeLeadershipPriorityResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static DescribeLeadershipPriorityResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeLeadershipPriorityResponse(new DescribeLeadershipPriorityResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

