/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;

public class PublicCredential {
    private static final Set<SecurityProtocol> SASL_PROTOCOLS = Utils.mkSet(SecurityProtocol.SASL_SSL, SecurityProtocol.SASL_PLAINTEXT);
    private static final Set<SecurityProtocol> ALL_PROTOCOLS = Utils.mkSet(SecurityProtocol.values());
    private final String authenticationId;
    private final Set<SecurityProtocol> securityProtocols;
    private final String saslMechanism;

    private PublicCredential(String authenticationId, Set<SecurityProtocol> securityProtocols, String saslMechanism) {
        this.authenticationId = authenticationId;
        this.securityProtocols = securityProtocols;
        this.saslMechanism = saslMechanism;
    }

    public String authenticationId() {
        return this.authenticationId;
    }

    public Set<SecurityProtocol> securityProtocols() {
        return this.securityProtocols;
    }

    public String saslMechanism() {
        return this.saslMechanism;
    }

    public boolean matches(PublicCredential matchingCredential) {
        if (matchingCredential != null) {
            return this.matches(this.authenticationId, matchingCredential.authenticationId) && this.matches(this.securityProtocols, matchingCredential.securityProtocols) && this.matches(this.saslMechanism, matchingCredential.saslMechanism);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicCredential)) {
            return false;
        }
        PublicCredential that = (PublicCredential)o;
        return Objects.equals(this.authenticationId, that.authenticationId) && Objects.equals(this.securityProtocols, that.securityProtocols) && Objects.equals(this.saslMechanism, that.saslMechanism);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationId, this.securityProtocols, this.saslMechanism);
    }

    public String toString() {
        return "PublicCredential{authenticationId='" + this.authenticationId + '\'' + ", securityProtocols=" + this.securityProtocols + ", saslMechanism='" + this.saslMechanism + '\'' + '}';
    }

    private boolean matches(String a, String b) {
        return a == null || b == null || a.equals(b);
    }

    private boolean matches(Set<SecurityProtocol> a, Set<SecurityProtocol> b) {
        return b.stream().anyMatch(a::contains);
    }

    public static PublicCredential authenticatedCredential(String authenticationId, SecurityProtocol securityProtocol, String saslMechanism) {
        if (saslMechanism == null) {
            if (SASL_PROTOCOLS.contains((Object)securityProtocol)) {
                throw new IllegalArgumentException("SASL mechanism not specified for security protocol " + (Object)((Object)securityProtocol));
            }
        } else if (!SASL_PROTOCOLS.contains((Object)securityProtocol)) {
            throw new IllegalArgumentException("SASL mechanism cannot be applied to security protocol " + (Object)((Object)securityProtocol));
        }
        return new PublicCredential(authenticationId, Collections.singleton(securityProtocol), saslMechanism);
    }

    public static PublicCredential saslCredential(String authenticationId, String saslMechanism) {
        return new PublicCredential(authenticationId, SASL_PROTOCOLS, saslMechanism);
    }

    public static PublicCredential credential(String authenticationId, SecurityProtocol securityProtocol, String saslMechanism) {
        Set<SecurityProtocol> securityProtocols = securityProtocol == null ? ALL_PROTOCOLS : Collections.singleton(securityProtocol);
        return new PublicCredential(authenticationId, securityProtocols, saslMechanism);
    }
}

