/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class SaslAuthenticateRequestDataJsonConverter {
    public static SaslAuthenticateRequestData read(JsonNode _node, short _version) {
        SaslAuthenticateRequestData _object = new SaslAuthenticateRequestData();
        JsonNode _authBytesNode = _node.get("authBytes");
        if (_authBytesNode == null) {
            throw new RuntimeException("SaslAuthenticateRequestData: unable to locate field 'authBytes', which is mandatory in version " + _version);
        }
        _object.authBytes = MessageUtil.jsonNodeToBinary(_authBytesNode, "SaslAuthenticateRequestData");
        JsonNode _networkRegionIdNode = _node.get("networkRegionId");
        if (_networkRegionIdNode == null) {
            _object.networkRegionId = null;
        } else if (_networkRegionIdNode.isNull()) {
            _object.networkRegionId = null;
        } else {
            if (!_networkRegionIdNode.isTextual()) {
                throw new RuntimeException("SaslAuthenticateRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.networkRegionId = _networkRegionIdNode.asText();
        }
        return _object;
    }

    public static JsonNode write(SaslAuthenticateRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("authBytes", (JsonNode)new BinaryNode(Arrays.copyOf(_object.authBytes, _object.authBytes.length)));
        if (_version >= 2) {
            if (_object.networkRegionId != null) {
                _node.set("networkRegionId", (JsonNode)new TextNode(_object.networkRegionId));
            }
        } else if (_object.networkRegionId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default networkRegionId at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(SaslAuthenticateRequestData _object, short _version) {
        return SaslAuthenticateRequestDataJsonConverter.write(_object, _version, true);
    }
}

